/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.tutorial;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JToolBar;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.plugin.jas3.tutorial.TutorialCommands;
import org.xml.sax.SAXException;

public class TutorialPlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(TutorialPlugin.class.getName());

    protected void init() throws SAXException, IOException {
        logger.info("Initializing tutorial plugin");
        Studio studio = (Studio)Studio.getApplication();
        this.addMenuItemsAndToolbar(studio);
        this.registerCommandHandler(studio);
    }

    protected void postInit() {
        logger.info("Post init tutorial plugin");
    }

    private void addMenuItemsAndToolbar(Studio studio) throws SAXException, IOException {
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("Tutorial.menus");
        builder.build(xml);
        JToolBar toolbar = builder.getToolBar("tutorialToolbar");
        studio.addToolBar(toolbar, toolbar.getName());
    }

    private void registerCommandHandler(Studio studio) {
        studio.getCommandTargetManager().add((CommandGroup)new TutorialCommands(studio));
    }
}

