/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.elog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.elog.ELogConnectionUtils;
import org.lsst.ccs.elog.ElogEntry;
import org.lsst.ccs.plugin.jas3.elog.LsstElogAttachment;

public class LsstElogSubmissionDialog
extends JPanel {
    private ElogEntry entry;
    private ArrayList<LsstElogAttachment> attachments = new ArrayList();
    private JButton addAttachmentButton;
    private JPanel attachmentsPanel;
    private JComboBox categoryComboBox;
    private JTextArea entryTextArea;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JButton submitEntryButton;
    private JTextField tagsTextField;

    public LsstElogSubmissionDialog() {
        this.entry = new ElogEntry();
        this.entry.setCategory("Testing");
        this.initComponents();
        try {
            List categories = ELogConnectionUtils.getCategories();
            String[] cats = new String[categories.size()];
            int count = 0;
            for (String cat : categories) {
                cats[count++] = cat;
            }
            this.categoryComboBox.setModel(new DefaultComboBoxModel<String>(cats));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.entryTextArea = new JTextArea();
        this.jLabel3 = new JLabel();
        this.addAttachmentButton = new JButton();
        this.tagsTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.submitEntryButton = new JButton();
        this.attachmentsPanel = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.categoryComboBox = new JComboBox();
        this.setPreferredSize(new Dimension(484, 280));
        this.jLabel1.setText("Category:");
        this.jLabel2.setText("Entry Text:");
        this.entryTextArea.setColumns(20);
        this.entryTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.entryTextArea);
        this.jLabel3.setText("Attachments:");
        this.addAttachmentButton.setText("Add Attachment ...");
        this.addAttachmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.addAttachmentButtonActionPerformed(evt);
            }
        });
        this.tagsTextField.setEnabled(false);
        this.tagsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.tagsTextFieldActionPerformed(evt);
            }
        });
        this.jLabel4.setText("List of Tags:");
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("New Elog Entry Form");
        this.submitEntryButton.setText("Submit Elog Entry");
        this.submitEntryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.submitEntryButtonActionPerformed(evt);
            }
        });
        this.attachmentsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.attachmentsPanel.setAlignmentY(1.0f);
        this.attachmentsPanel.setMinimumSize(new Dimension(40, 40));
        this.attachmentsPanel.setLayout(new BoxLayout(this.attachmentsPanel, 1));
        this.filler1.setAlignmentY(1.0f);
        this.filler1.setAutoscrolls(true);
        this.attachmentsPanel.add(this.filler1);
        this.categoryComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.categoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LsstElogSubmissionDialog.this.categoryComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1).addComponent(this.tagsTextField).addComponent(this.categoryComboBox, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addAttachmentButton).addComponent(this.attachmentsPanel, -2, 386, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.submitEntryButton).addGap(205, 205, 205)).addGroup(layout.createSequentialGroup().addGap(358, 358, 358).addComponent(this.jLabel6).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jLabel6).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.categoryComboBox, -2, -1, -2)).addComponent(this.addAttachmentButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagsTextField, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane1, -2, 182, -2))).addComponent(this.attachmentsPanel, -2, 219, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitEntryButton).addContainerGap(191, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName("");
    }

    private void tagsTextFieldActionPerformed(ActionEvent evt) {
    }

    private void submitEntryButtonActionPerformed(ActionEvent evt) {
        try {
            this.entry.setFormName("default");
            this.entry.setFormField("text", this.entryTextArea.getText());
            String tags = this.tagsTextField.getText();
            StringTokenizer tok = new StringTokenizer(tags, ",");
            while (tok.hasMoreTokens()) {
                this.entry.addTag(tok.nextToken());
            }
            ELogConnectionUtils.postEntryToElog((ElogEntry)this.entry);
            this.entry.reset();
            SwingUtilities.invokeLater(new ClearDialog());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addAttachmentButtonActionPerformed(ActionEvent evt) {
        JFileChooser dlg = new JFileChooser();
        dlg.setDialogTitle("Select an Image");
        dlg.setApproveButtonText("Select");
        if (dlg.showOpenDialog(this) == 0) {
            File file = dlg.getSelectedFile();
            try {
                String fileName = file.getName();
                LsstElogAttachment attach = new LsstElogAttachment(fileName, ElogEntry.isFileImage((String)fileName), this);
                this.attachments.add(attach);
                this.entry.addFile(fileName, file);
                SwingUtilities.invokeLater(new AddAttachment(attach));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void categoryComboBoxActionPerformed(ActionEvent evt) {
        this.entry.setCategory((String)this.categoryComboBox.getSelectedItem());
    }

    void removeAttachment(LsstElogAttachment attach) {
        this.attachments.remove(attach);
        this.entry.removeAttachment(attach.getFileName(), attach.isImage());
        SwingUtilities.invokeLater(new RemoveAttachment(attach));
    }

    private class AddAttachment
    implements Runnable {
        private LsstElogAttachment attach;

        AddAttachment(LsstElogAttachment attach) {
            this.attach = attach;
        }

        @Override
        public void run() {
            LsstElogSubmissionDialog.this.attachmentsPanel.add((Component)this.attach, 0);
        }
    }

    private class ClearDialog
    implements Runnable {
        ClearDialog() {
        }

        @Override
        public void run() {
            for (LsstElogAttachment attach : LsstElogSubmissionDialog.this.attachments) {
                LsstElogSubmissionDialog.this.attachmentsPanel.remove(attach);
            }
            LsstElogSubmissionDialog.this.attachmentsPanel.revalidate();
            LsstElogSubmissionDialog.this.attachments.clear();
            LsstElogSubmissionDialog.this.entryTextArea.setText("");
            LsstElogSubmissionDialog.this.tagsTextField.setText("");
        }
    }

    private class RemoveAttachment
    implements Runnable {
        private LsstElogAttachment attach;

        RemoveAttachment(LsstElogAttachment attach) {
            this.attach = attach;
        }

        @Override
        public void run() {
            LsstElogSubmissionDialog.this.attachmentsPanel.remove(this.attach);
            LsstElogSubmissionDialog.this.attachmentsPanel.revalidate();
        }
    }
}

