package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @author turri
 */
public class TimeSelection {
    
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public String name, lowerEdgeString, upperEdgeString;
    
    public TimeSelection(String name, String lowerEdgeString, String upperEdgeString) {
        this.name = name;
        this.lowerEdgeString = lowerEdgeString;
        this.upperEdgeString = upperEdgeString;
    }
    
    public long getLowerEdge() {
        try {
            Date d = dateFormat.parse(lowerEdgeString);
            return d.getTime();
        } catch (Exception e) {
        }
        try {
            return (long)(1000*TimeSelectionUtils.getSecondsForString(lowerEdgeString));        
        } catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
    
    public long getUpperEdge() {
        try {
            Date d = dateFormat.parse(upperEdgeString);
            return d.getTime();
        } catch (Exception e) {
        }
        try {
            return (long)(1000*TimeSelectionUtils.getSecondsForString(upperEdgeString));        
        } catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public String toString() {
        return name;
    }
    
    
    
    
}
