package org.lsst.ccs.plugin.jas3.trending.timeselection;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;

/**
 *
 * @author turri
 */
public class Compiler {

    public static TimeSelectionCompiledExpression compile(String expression) throws CompilationException {
        // Set up the library
        Class[] staticLib = { java.lang.Math.class };
        Class[] dynamicLib = { TimeSelectionEvaluator.class };
        Class[] dotLib = { Object.class, String.class, java.util.Date.class };
        Library lib=new Library(staticLib, dynamicLib, dotLib, new TimeSelectionNameResolver(), null);
        lib.markStateDependent("random",null);
        CompiledExpression cexpr = Evaluator.compile(expression,lib,null);
        return new TimeSelectionCompiledExpression(cexpr);
    }
}
