package org.lsst.ccs.plugin.jas3.jms;

import javax.swing.JComponent;
import org.freehep.jas.services.PreferencesTopic;

/**
 * A JAS preferences topic, which allows the restful server location to be controlled
 * from the JAS preferences panel.
 * @author turri
 */
class JmsPreferencesTopic implements PreferencesTopic {

    private final String[] jmsPreferencesPath = {"LSST","Messaging","JMS"};
    private final JmsPreferences prefs;
    
    JmsPreferencesTopic(JmsPreferences prefs) {
        this.prefs = prefs;
    }
    
    @Override
    public boolean apply(JComponent panel) {
        JmsPreferencesPanel jp = (JmsPreferencesPanel) panel;
        jp.apply();
        return true;
    }


    @Override
    public String[] path() {
        return jmsPreferencesPath;
    }

    @Override
    public JComponent component() {
        return new JmsPreferencesPanel(prefs);
    } 
}
