package org.lsst.ccs.plugin.jas3.elog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.lsst.ccs.elog.ELogConnectionUtils;
import org.lsst.ccs.elog.ElogEntry;
import org.lsst.ccs.elog.ElogTransactionResult;

/**
 *
 * @author turri
 */
public class LsstElogSubmissionDialog extends javax.swing.JPanel {

    private ElogEntry entry;
    private ArrayList<LsstElogAttachment> attachments = new ArrayList<LsstElogAttachment>();

    /**
     * Creates new form LsstElogSubmissionDialog
     */
    public LsstElogSubmissionDialog() {
        entry = new ElogEntry();
        entry.setCategory("Testing");
        initComponents();

        try {
            List<String> categories = ELogConnectionUtils.getCategories();
            String[] cats = new String[categories.size()];
            int count = 0;
            for (String cat : categories) {
                cats[count++] = cat;
            }
            categoryComboBox.setModel(new javax.swing.DefaultComboBoxModel(cats));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        entryTextArea = new javax.swing.JTextArea();
        jLabel3 = new javax.swing.JLabel();
        addAttachmentButton = new javax.swing.JButton();
        tagsTextField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        submitEntryButton = new javax.swing.JButton();
        attachmentsPanel = new javax.swing.JPanel();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 32767));
        categoryComboBox = new javax.swing.JComboBox();

        setPreferredSize(new java.awt.Dimension(484, 280));

        jLabel1.setText("Category:");

        jLabel2.setText("Entry Text:");

        entryTextArea.setColumns(20);
        entryTextArea.setRows(5);
        jScrollPane1.setViewportView(entryTextArea);

        jLabel3.setText("Attachments:");

        addAttachmentButton.setText("Add Attachment ...");
        addAttachmentButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addAttachmentButtonActionPerformed(evt);
            }
        });

        tagsTextField.setEnabled(false);
        tagsTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tagsTextFieldActionPerformed(evt);
            }
        });

        jLabel4.setText("List of Tags:");

        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel6.setText("New Elog Entry Form");

        submitEntryButton.setText("Submit Elog Entry");
        submitEntryButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                submitEntryButtonActionPerformed(evt);
            }
        });

        attachmentsPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        attachmentsPanel.setAlignmentY(1.0F);
        attachmentsPanel.setMinimumSize(new java.awt.Dimension(40, 40));
        attachmentsPanel.setLayout(new javax.swing.BoxLayout(attachmentsPanel, javax.swing.BoxLayout.Y_AXIS));

        filler1.setAlignmentY(1.0F);
        filler1.setAutoscrolls(true);
        attachmentsPanel.add(filler1);

        categoryComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        categoryComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                categoryComboBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(24, 24, 24)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel2)
                    .addComponent(jLabel4)
                    .addComponent(jLabel1))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jScrollPane1)
                    .addComponent(tagsTextField)
                    .addComponent(categoryComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel3)
                .addGap(3, 3, 3)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(addAttachmentButton)
                    .addComponent(attachmentsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 386, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(submitEntryButton)
                .addGap(205, 205, 205))
            .addGroup(layout.createSequentialGroup()
                .addGap(358, 358, 358)
                .addComponent(jLabel6)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(26, 26, 26)
                .addComponent(jLabel6)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel1)
                        .addComponent(categoryComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(addAttachmentButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(tagsTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel4)
                            .addComponent(jLabel3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 182, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(attachmentsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 219, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(submitEntryButton)
                .addContainerGap(191, Short.MAX_VALUE))
        );

        getAccessibleContext().setAccessibleName("");
    }// </editor-fold>//GEN-END:initComponents

    private void tagsTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tagsTextFieldActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_tagsTextFieldActionPerformed

    private void submitEntryButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_submitEntryButtonActionPerformed

        try {
            entry.setFormName("default");
            entry.setFormField("text", entryTextArea.getText());

            String tags = tagsTextField.getText();
            StringTokenizer tok = new StringTokenizer(tags, ",");
            while (tok.hasMoreTokens()) {
                entry.addTag(tok.nextToken());
            }
            ElogTransactionResult result = ELogConnectionUtils.postEntryToElog(entry);
            entry.reset();
            SwingUtilities.invokeLater(new ClearDialog());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }//GEN-LAST:event_submitEntryButtonActionPerformed

    private void addAttachmentButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addAttachmentButtonActionPerformed
        JFileChooser dlg = new JFileChooser();
        dlg.setDialogTitle("Select an Image");
        dlg.setApproveButtonText("Select");
        if (dlg.showOpenDialog(LsstElogSubmissionDialog.this) == JFileChooser.APPROVE_OPTION) {
            final File file = dlg.getSelectedFile();
            try {
                String fileName = file.getName();
                LsstElogAttachment attach = new LsstElogAttachment(fileName, ElogEntry.isFileImage(fileName), LsstElogSubmissionDialog.this);
                attachments.add(attach);
                entry.addFile(fileName, file);
                SwingUtilities.invokeLater(new AddAttachment(attach));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }//GEN-LAST:event_addAttachmentButtonActionPerformed

    private void categoryComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_categoryComboBoxActionPerformed
        entry.setCategory((String) categoryComboBox.getSelectedItem());
    }//GEN-LAST:event_categoryComboBoxActionPerformed

    void removeAttachment(LsstElogAttachment attach) {
        attachments.remove(attach);
        entry.removeAttachment(attach.getFileName(), attach.isImage());
        SwingUtilities.invokeLater(new RemoveAttachment(attach));
    }

    private class ClearDialog implements Runnable {

        ClearDialog() {
        }

        @Override
        public void run() {
            for (LsstElogAttachment attach : attachments) {
                attachmentsPanel.remove(attach);
            }
            attachmentsPanel.revalidate();
            attachments.clear();
            entryTextArea.setText("");
            tagsTextField.setText("");
        }
    }

    private class AddAttachment implements Runnable {

        private LsstElogAttachment attach;

        AddAttachment(LsstElogAttachment attach) {
            this.attach = attach;
        }

        @Override
        public void run() {
            attachmentsPanel.add(attach, 0);
        }
    }

    private class RemoveAttachment implements Runnable {

        private LsstElogAttachment attach;

        RemoveAttachment(LsstElogAttachment attach) {
            this.attach = attach;
        }

        @Override
        public void run() {
            attachmentsPanel.remove(attach);
            attachmentsPanel.revalidate();
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addAttachmentButton;
    private javax.swing.JPanel attachmentsPanel;
    private javax.swing.JComboBox categoryComboBox;
    private javax.swing.JTextArea entryTextArea;
    private javax.swing.Box.Filler filler1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton submitEntryButton;
    private javax.swing.JTextField tagsTextField;
    // End of variables declaration//GEN-END:variables
}
