/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelectionUtils;

public class TimeSelection {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public String name;
    public String lowerEdgeString;
    public String upperEdgeString;

    public TimeSelection(String name, String lowerEdgeString, String upperEdgeString) {
        this.name = name;
        this.lowerEdgeString = lowerEdgeString;
        this.upperEdgeString = upperEdgeString;
    }

    public long getLowerEdge() {
        try {
            Date d = dateFormat.parse(this.lowerEdgeString);
            return d.getTime();
        }
        catch (Exception exception) {
            try {
                return (long)(1000.0 * TimeSelectionUtils.getSecondsForString(this.lowerEdgeString));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public long getUpperEdge() {
        try {
            Date d = dateFormat.parse(this.upperEdgeString);
            return d.getTime();
        }
        catch (Exception exception) {
            try {
                return (long)(1000.0 * TimeSelectionUtils.getSecondsForString(this.upperEdgeString));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

