/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.console;

import java.awt.Component;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.DetailLevel;
import org.lsst.ccs.bus.StatusListener;

class AlarmListener
implements StatusListener,
Runnable {
    private final Studio studio;
    private JDialog dialog;
    private final Console console;
    private final PrintWriter printWriter;

    public AlarmListener(Studio studio) {
        this.studio = studio;
        this.console = new Console();
        this.printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.console.getOutputStream(null)), true);
    }

    public void onStatus(BusMessage bm) {
        if (bm.getDetailLevel() == DetailLevel.SEVERE) {
            this.ensureDialogVisible();
            this.printWriter.println(bm);
        }
    }

    @Override
    public void run() {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        if (!this.dialog.isVisible()) {
            this.dialog.setVisible(true);
        }
    }

    private void ensureDialogVisible() {
        SwingUtilities.invokeLater(this);
    }

    private JDialog createDialog() {
        JOptionPane pane = new JOptionPane();
        pane.setMessageType(0);
        pane.setOptions(new Object[]{"Clear Alarm"});
        pane.setMessage(new JScrollPane((Component)this.console));
        JDialog dlg = pane.createDialog((Component)this.studio, "Alarm");
        dlg.setResizable(true);
        dlg.setModal(false);
        dlg.setAlwaysOnTop(true);
        return dlg;
    }
}

