package org.lsst.ccs.plugin.jas3.console;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.StatusListener;

/**
 * New implementation of basic tracer. This version based vaguely on Bernard's
 * StatusTestComponent.
 *
 * @author tonyj
 */
public class Tracer implements PageListener, StatusListener, HasPopupItems {
    private final MessagingFactory factory;
    private PrintWriter out;
    private MessageFilter filter = new RegularExpressionMessageFilter();

    Tracer(MessagingFactory factory) {
        this.factory = factory;
    }

    @Override
    public void onStatus(BusMessage bm) {
        if (filter == null || filter.accept(bm)) out.println(bm);
    }

    @Override
    public void pageChanged(PageEvent pe) {
        if (pe.getID() == PageEvent.PAGECLOSED) {
            factory.shutdownBusAccess();
        }
    }

    void start(PrintWriter out) {
        this.out = out;
        factory.addStatusListener(this);
    }

    @Override
    public JPopupMenu modifyPopupMenu(JPopupMenu menu, final Component source, Point p) {
        JMenuItem item = new JMenuItem("Set Filter...");
        item.addActionListener(new ActionListener()
        {
            @Override
            public void actionPerformed(ActionEvent e) {
                RegularExpressionMessageFilter regexFilter = (RegularExpressionMessageFilter) filter;
                RegularExpressionMessageFilterPanel fp = new RegularExpressionMessageFilterPanel(regexFilter);
                int rc = JOptionPane.showConfirmDialog(Application.getApplication(), fp, "Select Filter", JOptionPane.OK_CANCEL_OPTION);
                if (rc == JOptionPane.OK_OPTION) {
                    fp.apply();
                }
            }
            
        });
        menu.insert(item,0);
        return menu;
    }
}
