/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3;

import java.io.PrintWriter;
import java.util.UUID;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandReply;

class Tracer
extends Subsystem
implements PageListener {
    private final PrintWriter out;

    Tracer(PrintWriter out) {
        String name = "tracer_" + UUID.randomUUID().toString();
        this.setName(name);
        this.out = out;
        this.setListenToStatus(true);
        this.setStatusBusSelector("");
        this.setStatusBroadcastPeriod(0);
    }

    public void onStatus(BusMessage s) {
        this.out.println(s);
    }

    public void onCommand(Command cmd) {
        this.out.println(cmd + " correl(" + cmd.getCorrelId() + ")");
    }

    public void onReply(CommandReply cmd) {
        this.out.println(cmd + " correl(" + cmd.getCorrelId() + ")");
    }

    public void onAck(CommandAck cmd) {
        System.out.println("CommandAck " + cmd + " reply correl(" + cmd.getCorrelId() + ")");
    }

    public void pageChanged(PageEvent pe) {
        if (pe.getID() == 4001) {
            this.shutdown();
        }
    }
}

