/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.plugin.jas3.CommandConsole;
import org.lsst.ccs.plugin.jas3.Tracer;
import org.xml.sax.SAXException;

public class LsstConsolePlugin
extends Plugin {
    private String defaultConsoleName = "LSST Console";
    private String defaultTracerName = "LSST Tracer";

    protected void init() throws SAXException, IOException {
        Studio studio = (Studio)Studio.getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add((Object)this);
        studio.getCommandTargetManager().add((CommandGroup)new ConsoleCommands());
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("LsstConsolePlugin.menus");
        builder.build(xml);
    }

    private Console createCommandConsole(String name) {
        Studio studio = (Studio)Studio.getApplication();
        try {
            FreeHEPLookup lookup = studio.getLookup();
            ConsoleService cs = (ConsoleService)lookup.lookup(ConsoleService.class);
            if (cs != null) {
                Console console = cs.createConsole(name, null);
                final CommandConsole command = new CommandConsole(console);
                Thread t = new Thread("ConsoleInput-" + name){

                    @Override
                    public void run() {
                        command.start();
                        command.runConsole();
                    }
                };
                t.start();
                return console;
            }
        }
        catch (Exception e) {
            studio.error("Failed to start Console: " + name, (Throwable)e);
        }
        return null;
    }

    private Console createTracerConsole(String name) {
        Studio studio = (Studio)Studio.getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        ConsoleService cs = (ConsoleService)lookup.lookup(ConsoleService.class);
        if (cs != null) {
            Console console = cs.createConsole(name, null);
            ConsoleOutputStream out = console.getOutputStream(null);
            PrintWriter pw = new PrintWriter((OutputStream)out, true);
            Tracer tracer = new Tracer(pw);
            cs.getPageContextForConsole(console).addPageListener((PageListener)tracer);
            tracer.start();
            return console;
        }
        return null;
    }

    public class ConsoleCommands
    extends CommandProcessor {
        public void onLsstConsole() {
            LsstConsolePlugin.this.createCommandConsole(LsstConsolePlugin.this.defaultConsoleName);
        }

        public void onLsstTracer() {
            LsstConsolePlugin.this.createTracerConsole(LsstConsolePlugin.this.defaultTracerName);
        }
    }
}

