package org.lsst.ccs.plugin.jas3.preferences;

import javax.swing.JComponent;
import org.freehep.jas.services.PreferencesTopic;
import org.lsst.ccs.plugin.jas3.LsstPlugin;

/**
 *
 * @author turri
 */
public class ServersPreferencesTopic implements PreferencesTopic {

    private LsstPlugin lsstPlugin;
    private String[] serversPreferencesPath = {"LSST","Servers"};
    private ServersPreferencesPanel serversPreferencesPanel = null;

    
    public ServersPreferencesTopic(LsstPlugin lsstPlugin) {
        this.lsstPlugin = lsstPlugin;
    }
    
    @Override
    public boolean apply(JComponent panel) {
        ServersPreferencesPanel prefs = (ServersPreferencesPanel) panel;
        prefs.apply();
        if (prefs.getJmsPreferences().getHasChanged()) {
            prefs.enableJmsPreferences(false);
            lsstPlugin.resetBuses();
            lsstPlugin.setBusesSystemProperties(prefs.getJmsPreferences());
            lsstPlugin.initializeBuses();
            prefs.getJmsPreferences().reset();
        }

        if (prefs.getRestPreferences().getHasChanged()) {
            prefs.enableRestPreferences(false);
            try {
                lsstPlugin.resetRestServices();
            } catch (Exception e) {
            }
//            lsstPlugin.initializeRestServices(prefs.getRestPreferences());
            prefs.getRestPreferences().reset();
        }
        return true;
    }


    @Override
    public String[] path() {
        return serversPreferencesPath;
    }

    @Override
    public JComponent component() {
        serversPreferencesPanel = new ServersPreferencesPanel();
        return serversPreferencesPanel;
    }
    
    public ServersPreferencesPanel getServersPareferencesPanel() {
        return serversPreferencesPanel;
    }

    
    
    
}
