/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.plugin.jas3.preferences;

import org.freehep.application.studio.Studio;

/**
 *
 * @author turri
 */
public class RestPreferences {
    
    private String server, port;
    boolean hasInformationChanged = false;
    
    public RestPreferences() {
        server = ((Studio)Studio.getApplication()).getUserProperties().getProperty("org.lsst.rest.server", "localhost");
        port = ((Studio)Studio.getApplication()).getUserProperties().getProperty("org.lsst.rest.port", "8080");
    }

    public String getRestPort() {
        return port;
    }

    public String getRestServer() {
        return server;
    }
    
    public void setRestPort(String port) {
        if (!this.port.equals(port)) {
            hasInformationChanged = true;
            this.port = port;
            ((Studio) Studio.getApplication()).getUserProperties().setProperty("org.lsst.jms.port", port);
        }
    }

    public void setRestServer(String server) {
        if (!this.server.equals(server)) {
            hasInformationChanged = true;
            this.server = server;
            ((Studio)Studio.getApplication()).getUserProperties().setProperty("org.lsst.rest.server", server);
        }
    }
    
    public boolean getHasChanged() {
        return hasInformationChanged;
    }
    
    public void reset() {
        hasInformationChanged = false;
    }
    
}
