/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.plugin.jas3.adapters;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPoint;
import hep.aida.IPlotterStyle;
import hep.aida.ITree;
import hep.aida.ref.histogram.DataPointSet;
import hep.aida.ref.histogram.DataPointSetFactory;
import hep.aida.ref.plotter.PlotterFactory;
import hep.aida.ref.plotter.PlotterStyle;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeObjectProvider;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandState;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.plugin.jas3.LsstPlugin;
import org.lsst.ccs.plugin.jas3.TimeHistory;
import org.lsst.ccs.plugin.jas3.timeselection.TimeSelection;

/**
 *
 * @author turri
 */
public class DataChannelTreeAdapter extends DefaultFTreeNodeAdapter {

    static Hashtable<String, PlotPage> plotPageHash = new Hashtable<String, PlotPage>();
    private Studio app;
    FTreeNodeObjectProvider objectProvider = new DataChannelObjectProvider();
    private LsstPlugin lsstPlugin;
    PlotterFactory plotterStyleFactory = new PlotterFactory();
    private Commands commands = new Commands();

    public DataChannelTreeAdapter(LsstPlugin lsstPlugin) {
        super(100);
        this.lsstPlugin = lsstPlugin;
        app = (Studio) Studio.getApplication();
    }

    public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
        commands.setSelectedNodes(selectedNodes);
        return commands;
    }

    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        commands.setSelectedNodes(nodes);
        if (menu.getSubElements().length != 0) {
            menu.addSeparator();
        }
        JMenuItem item = new JMenuItem("Show");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        item = new JMenuItem("Overlay on Current Plot");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        item = new JMenuItem("Add to Current Plot");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        item = new JMenuItem("Show in New Plot");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        item = new JMenuItem("Show on New Page");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        menu.addSeparator();
        return menu;
    }

    @Override
    public FTreeNodeObjectProvider treeNodeObjectProvider(FTreeNode node) {
        return objectProvider;
    }

    public boolean doubleClick(FTreeNode node) {
        commands.setSelectedNodes(new FTreeNode[]{node});
        commands.onShow();
        return true;
    }

    class DataChannelObjectProvider implements FTreeNodeObjectProvider {

        public Object objectForNode(FTreeNode node, Class clazz) {
            Object obj = node.value(TimeHistory.class);
            return obj;
        }
    }

    public class Commands extends CommandProcessor {

        private FTreeNode[] selectedNodes;

        void setSelectedNodes(FTreeNode[] selectedNodes) {
            this.selectedNodes = selectedNodes;
        }

        public void onShow() {
            show(true, false, false, false);
        }

        public void onOverlayonCurrentPlot() {
            show(false, false, true, false);
        }

        public void onShowinNewPlot() {
            show(false, false, false, true);
        }

        public void onShowonNewPage() {
            show(false, true, false, false);
        }

        private void show(boolean useExistingPlot, boolean newPage, boolean overlay, boolean newPlot) {

            FTreeNode[] nodes = selectedNodes;
            DataChannel chan = dataChannel();

            if (chan != null) {
                PlotRegion region = null;

                PlotFactory pf = (PlotFactory) app.getLookup().lookup(PlotFactory.class);
                PlotPage page = null;
                if (newPage) {
                    page = pf.currentPage();
                } else if (useExistingPlot) {
                    page = plotPageHash.get(chan.getPathAsString());
                } else {
                    page = pf.currentPage();
                }

                if (page == null) {
                    page = pf.createPage(chan.getPathAsString());
                    page.createRegions(1, 1);
                    page.showPage();
                    plotPageHash.put(chan.getPathAsString(), page);
                }
                page.showPage();


                region = page.currentRegion();
                if (region == null) {
                    region = page.createRegion(0, 0, 1, 1);
                } else if (newPlot) {
                    region = page.addRegion();
                }
                Plotter plotter = region.currentPlot();

                if (plotter == null) {
                    plotter = pf.createPlotterFor(IBaseHistogram.class);
                }







                TimeHistory timeHistory = (TimeHistory) nodes[0].objectForClass(TimeHistory.class);
                if (timeHistory == null) {
                    timeHistory = new TimeHistory(chan);
                    nodes[0].addKey(TimeHistory.class, timeHistory);
                }


                TimeSelection selectedTimeSelection = lsstPlugin.getCurrentTimeSelection();
                long t1 = selectedTimeSelection.getLowerEdge();
                long t2 = selectedTimeSelection.getUpperEdge();

                Data data = lsstPlugin.getDataChannelData(chan.getId(), t1, t2);
                timeHistory.setDataArray(data.getTrendingResult().getTrendingDataArray());

                String nameAndTitle = chan.getPathAsString();
                DataPointSet pst = new DataPointSet(nameAndTitle, nameAndTitle, 2);

                for (int i = 0; i < timeHistory.size(); i++) {
                    TrendingData d = timeHistory.getData(i);

                    IDataPoint p = pst.addPoint();
                    p.coordinate(0).setValue(d.getAxisvalue().getValue() / 1000.);
                    p.coordinate(1).setValue(d.getValue("value"));
                }

                IPlotterStyle style = plotterStyleFactory.createPlotterStyle();


                style.xAxisStyle().setParameter("type", "date");
                style.setParameter("xAxisLowerLimit", String.valueOf(t1/1000));
                style.setParameter("xAxisUpperLimit", String.valueOf(t2/1000));

                plotter.plot(pst, overlay ? plotter.OVERLAY : plotter.NORMAL, style, "");

                region.showPlot(plotter);

            }
        }

        private DataChannel dataChannel() {
            FTreeNode[] nodes = selectedNodes;
            return (DataChannel) nodes[0].objectForClass(DataChannel.class);
        }
    }
}
