package org.lsst.ccs.plugin.jas3;

import java.io.PrintWriter;
import java.util.UUID;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandReply;

class Tracer extends Subsystem implements PageListener {

    private final PrintWriter out;

    Tracer(PrintWriter out) {

        String name = "tracer_" + UUID.randomUUID().toString();
        setName(name);
        this.out = out;
        setListenToStatus(true);
        setStatusBusSelector("");
        setStatusBroadcastPeriod(0);
    }

    @Override
    public void onStatus(BusMessage s) {
        out.println(s);
    }

    @Override
    public void onCommand(Command cmd) {
        out.println(cmd + " correl(" + cmd.getCorrelId() + ")");
    }

    @Override
    public void onReply(CommandReply cmd) {
        out.println(cmd + " correl(" + cmd.getCorrelId() + ")");
    }

    @Override
    public void onAck(CommandAck cmd) {
        System.out.println("CommandAck " + cmd + " reply correl(" + cmd.getCorrelId() + ")");
    }

    @Override
    public void pageChanged(PageEvent pe) {
        if (pe.getID() == PageEvent.PAGECLOSED) {
            shutdown();
        }
    }
}
