package org.lsst.ccs.plugin.jas3;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import org.freehep.application.ProgressMeter;
import org.freehep.jas.services.ProgressMeterProvider;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.plugin.jas3.adapters.DataChannelTreeAdapter;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.util.FreeHEPLookup;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import javax.swing.SwingUtilities;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.plugin.jas3.preferences.JmsPreferences;
import org.lsst.ccs.plugin.jas3.preferences.RestPreferences;
import org.lsst.ccs.plugin.jas3.preferences.ServersPreferencesTopic;
import org.lsst.ccs.plugin.jas3.preferences.TimeSelectionPreferencesTopic;
import org.lsst.ccs.plugin.jas3.timeselection.TimeSelection;
import org.lsst.ccs.plugin.jas3.timeselection.TimeSelectionComboBoxModel;
import org.openide.util.Lookup;
import org.openide.util.Lookup.Result;
import org.xml.sax.SAXException;

/**
 *
 * @author tonyj
 */
public class LsstPlugin extends Plugin {

    private static final Logger logger = Logger.getLogger(LsstPlugin.class.getName());
    private FTree tree;
    private static Studio studio;
    ClientConfig config = new DefaultClientConfig();
    Client client = Client.create(config);
    WebResource service;
    private ProgressMeterProvider progressMeterProvider;
    private ProgressMeter progressMeter;
    private ServersPreferencesTopic serversPreferencesTopic = null;
    private TimeSelectionPreferencesTopic timeSelectionPreferencesTopic = null;
    private TimeSelectionComboBoxModel comboBoxModel;

    @Override
    protected void init() throws SAXException, IOException {

        logger.finest("LSST plugin created");

        studio = (Studio) Studio.getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add(this);

        // Initialize JNDI
        JmsPreferences jmsPrefs = new JmsPreferences();
        setBusesSystemProperties(jmsPrefs);


        FTreeProvider treeProvider = (FTreeProvider) lookup.lookup(FTreeProvider.class);
        if (treeProvider != null) {
            treeProvider.treeNodeAdapterRegistry().registerNodeAdapter(new DataChannelTreeAdapter(this), DataChannel.class);
            tree = treeProvider.tree();
        }

        progressMeterProvider = (ProgressMeterProvider) lookup.lookup(ProgressMeterProvider.class);

        serversPreferencesTopic = new ServersPreferencesTopic(this);
        lookup.add(serversPreferencesTopic);

        timeSelectionPreferencesTopic = new TimeSelectionPreferencesTopic(this);
        lookup.add(timeSelectionPreferencesTopic);
        
        

        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = getClass().getResource("LsstPlugin.menus");
        builder.build(xml);

        JToolBar toolbar = builder.getToolBar("lsstPlugin");
        comboBoxModel = new TimeSelectionComboBoxModel();
        JComboBox box = new JComboBox();
        box.setModel(comboBoxModel);
        box.setEnabled(box.getItemCount() > 0);
        
        JLabel boxLabel = new JLabel("Trending Period: ");
        toolbar.add(boxLabel,0);
        toolbar.add(box,1);
        studio.addToolBar(toolbar,"Time Selection");        
        
        
        
//        studio.getCommandTargetManager().add(commands = new WebBrowserCommands());
//        studio.addToolBar(builder.getToolBar("webToolBar"), "Web Toolbar");

        
    }
    
    public TimeSelection getCurrentTimeSelection() {
        return (TimeSelection) comboBoxModel.getSelectedItem();
    }

    @Override
    protected void postInit() {
        initializeBuses();
        RestPreferences restPrefs = serversPreferencesTopic.getServersPareferencesPanel() != null ? serversPreferencesTopic.getServersPareferencesPanel().getRestPreferences() : new RestPreferences();
//        initializeRestServices(restPrefs);
    }

    public void initializeBuses() {
        SwingUtilities.invokeLater(new InitializeCommunicationBuses());
    }

    public void resetBuses() {
        Result result = FreeHEPLookup.instance().lookup(new Lookup.Template(Plugin.class));
        Collection plugins = result.allInstances();
        Iterator pluginsIter = plugins.iterator();
        while (pluginsIter.hasNext()) {
            Plugin p = (Plugin) pluginsIter.next();
            if (p instanceof LsstSubsystemPlugin) {
                ((LsstSubsystemPlugin) p).disconnectFromMessagingFactory();
            }
        }
    }

    void continueAfterBusesInitialized() {
        progressMeterProvider.freeProgressMeter(progressMeter);

        Result result = FreeHEPLookup.instance().lookup(new Lookup.Template(LsstSubsystemPlugin.class));
        Collection plugins = result.allInstances();
        Iterator pluginsIter = plugins.iterator();
        while (pluginsIter.hasNext()) {
            LsstSubsystemPlugin p = (LsstSubsystemPlugin) pluginsIter.next();
            p.connectToMessagingFactory();
        }
    }

    public void setBusesSystemProperties(JmsPreferences jmsPrefs) {
        System.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", jmsPrefs.getJmsServer());
        System.setProperty("org.omg.CORBA.ORBInitialPort", jmsPrefs.getJmsPort());
    }

    public void initializeRestServices(RestPreferences restPrefs) {
        SwingUtilities.invokeLater(new InitializeRestServices(restPrefs));
    }

    public void resetRestServices() {
        Result result = FreeHEPLookup.instance().lookup(new Lookup.Template(LsstSubsystemPlugin.class));
        Collection plugins = result.allInstances();
        Iterator pluginsIter = plugins.iterator();
        while (pluginsIter.hasNext()) {
            LsstSubsystemPlugin p = (LsstSubsystemPlugin) pluginsIter.next();
            p.resetRestServices();
        }
    }



    protected void registerChannelsForSubsystem(String subsystem) {
        DataChannel.DataChannelList channelList = service.path("dataserver").path("listchannels").accept(MediaType.TEXT_XML).get(DataChannel.DataChannelList.class);
        for (DataChannel chan : channelList.list) {
            String chanSubsystem = chan.getPath()[0];
            if (subsystem.equals(chanSubsystem)) {
                tree.treeChanged(new FTreeNodeAddedNotification(studio, chan.getPathAsString(), chan));
            }
        }

    }

    protected void removeChannelsForSubsystem(String subsystem) {
        DataChannel.DataChannelList channelList = service.path("dataserver").path("listchannels").accept(MediaType.TEXT_XML).get(DataChannel.DataChannelList.class);
        for (DataChannel chan : channelList.list) {
            String chanSubsystem = chan.getPath()[0];
            if (subsystem.equals(chanSubsystem)) {
                tree.treeChanged(new FTreeNodeRemovedNotification(studio, chan.getPathAsString()));
            }
            tree.treeChanged(new FTreeNodeRemovedNotification(studio, subsystem));
        }

    }

    public Data getDataChannelData(int id, long t1, long t2) {

        // stat to define the type of statistics
        // n to pass the number of bins, default = 30

        
        WebResource resource = service.path("dataserver").path("data").path(String.valueOf(id));
        resource = resource.queryParam("t1", String.valueOf(t1)).queryParam("t2", String.valueOf(t2)).queryParam("flavor", "raw");

        return resource.accept(MediaType.TEXT_XML).get(Data.class);
    }

//    public void loadTree(Application app) {
//        tree.treeChanged(new FTreeNodeAddedNotification(studio, app.name(), FTreeFolderNode.class));
//        try {
//            BufferedReader reader = app.getApplicationSupport().getReaderFromWeb(ApplicationConstants.treeStructureString, null, app.getApplicationParameterState());
//            String line = null;
//            try {
//                while ((line = reader.readLine()) != null) {
//                    StringTokenizer st = new StringTokenizer(line, " ");
//                    String name = st.nextToken();
//                    if (name.equals("Root")) {
//                        continue;
//                    }
//                    String fullPath = "/" + app.name() + st.nextToken();
//                    String thName = st.nextToken();
//                    String type = st.nextToken();
//
//                    createTimeHistoryForPath(thName, fullPath);
//                }
//            } finally {
//                reader.close();
//            }
//        } catch (IOException ieo) {
//            throw new RuntimeException("Problem getting value from web.", ieo);
//        }
//    }
    class InitializeCommunicationBuses implements Runnable {

        @Override
        public void run() {
            progressMeter = progressMeterProvider.getProgressMeter();
            progressMeter.setIndeterminate(true);
            progressMeter.setToolTipText("Initializing Buses");
            progressMeter.setShowStopButton(false);
            progressMeter.setVisible(true);
            progressMeter.setName("Connecting to Buses....");

            Thread t = new Thread() {

                public void run() {
                    try {
//                        MessagingFactory.resetInstance();
//                        QueueSessionFactory.getSessionFactory().reset();
//                        TopicSessionFactory.getSessionFactory().reset();
//                        TopicSessionFactory.getSessionFactory().getTopicSession();
//                        continueAfterBusesInitialized();
                    } catch (Exception ioe) {
                        studio.error("Failed to initialize the Buses", ioe);
                        progressMeterProvider.freeProgressMeter(progressMeter);
                    } finally {
                        if (serversPreferencesTopic.getServersPareferencesPanel() != null) {
                            serversPreferencesTopic.getServersPareferencesPanel().enableJmsPreferences(true);
                        }
                    }
                }
            };

            t.start();
        }
    }

    class InitializeRestServices implements Runnable {

        RestPreferences restPrefs;
        
        InitializeRestServices(RestPreferences restPrefs) {
            this.restPrefs = restPrefs;
        }
        
        @Override
        public void run() {
            String restFullUrl = "http://" + restPrefs.getRestServer();
            if (!"".equals(restPrefs.getRestPort())) {
                restFullUrl += ":" + restPrefs.getRestPort();
            }
            restFullUrl += "/rest/data";
            service = client.resource(restFullUrl);

            try {
                DataChannel.DataChannelList channelList = service.path("dataserver").path("listchannels").accept(MediaType.TEXT_XML).get(DataChannel.DataChannelList.class);

                Result result = FreeHEPLookup.instance().lookup(new Lookup.Template(LsstSubsystemPlugin.class));
                Collection plugins = result.allInstances();
                Iterator pluginsIter = plugins.iterator();
                while (pluginsIter.hasNext()) {
                    LsstSubsystemPlugin p = (LsstSubsystemPlugin) pluginsIter.next();
                    p.initializeRestServices();
                }
            } catch (Exception e) {
                studio.error("Failed to start Rest Services", e);
            } finally {
                if (serversPreferencesTopic.getServersPareferencesPanel() != null) {
                    serversPreferencesTopic.getServersPareferencesPanel().enableRestPreferences(true);
                }
            }
        }
    }

}
