/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.plugin.jas3.CommandConsole;
import org.lsst.ccs.plugin.jas3.LsstPlugin;
import org.lsst.ccs.plugin.jas3.Tracer;

public abstract class LsstSubsystemPlugin
extends Plugin {
    public static Hashtable<String, Tracer> tracersMap = new Hashtable();

    public abstract void connectToMessagingFactory();

    public abstract void disconnectFromMessagingFactory();

    public abstract void initializeRestServices();

    public abstract void resetRestServices();

    public static void registerChannelsForSubsystem(String subsystem) {
        Studio studio = (Studio)Studio.getApplication();
        LsstPlugin lsstPlugin = (LsstPlugin)((Object)studio.getLookup().lookup(LsstPlugin.class));
        lsstPlugin.registerChannelsForSubsystem(subsystem);
    }

    public static void removeChannelsForSubsystem(String subsystem) {
        Studio studio = (Studio)Studio.getApplication();
        LsstPlugin lsstPlugin = (LsstPlugin)((Object)studio.getLookup().lookup(LsstPlugin.class));
        lsstPlugin.removeChannelsForSubsystem(subsystem);
    }

    public static Console createTracerConsole(String name, String selector) {
        if (tracersMap.containsKey(name)) {
            throw new RuntimeException("Tracer with name : " + name + " already exists ");
        }
        final Studio studio = (Studio)Studio.getApplication();
        try {
            FreeHEPLookup lookup = studio.getLookup();
            ConsoleService cs = (ConsoleService)lookup.lookup(ConsoleService.class);
            if (cs != null) {
                Console console = cs.createConsole(name, null);
                ConsoleOutputStream out = console.getOutputStream(null);
                PrintWriter pw = new PrintWriter((OutputStream)out, true);
                final Tracer tracer = new Tracer(name, selector, pw);
                tracersMap.put(name, tracer);
                tracer.setName(name);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            tracer.setListenToStatus(true);
                            tracer.setStatusBroadcastPeriod(0);
                            tracer.start();
                        }
                        catch (Exception e) {
                            studio.error("Problem when connecting to the buses", (Throwable)e);
                        }
                    }
                };
                t.start();
                return console;
            }
        }
        catch (Exception e) {
            studio.error("Failed to start Tracer: " + name, (Throwable)e);
        }
        return null;
    }

    public static Console createCommandConsole(String name) {
        Studio studio = (Studio)Studio.getApplication();
        try {
            FreeHEPLookup lookup = studio.getLookup();
            ConsoleService cs = (ConsoleService)lookup.lookup(ConsoleService.class);
            if (cs != null) {
                Console console = cs.createConsole(name, null);
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)console.getInputStream("console>")));
                ConsoleOutputStream out = console.getOutputStream(null);
                PrintWriter pw = new PrintWriter((OutputStream)out, true);
                final CommandConsole command = new CommandConsole(in, pw, name);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        command.start();
                    }
                };
                t.start();
                return console;
            }
        }
        catch (Exception e) {
            studio.error("Failed to start Console: " + name, (Throwable)e);
        }
        return null;
    }

    public static void closeTracerConsole(String name) {
        LsstSubsystemPlugin.closeConsole(name);
    }

    public static void closeCommandConsole(String name) {
        LsstSubsystemPlugin.closeConsole(name);
    }

    private static void closeConsole(String name) {
        Console console;
        Studio studio;
        ConsoleService cs;
        Tracer t = tracersMap.remove(name);
        if (t != null) {
            t.shutdown();
        }
        if ((cs = (ConsoleService)(studio = (Studio)Studio.getApplication()).getLookup().lookup(ConsoleService.class)) != null && (console = cs.getConsole(name)) != null) {
            console.close();
        }
    }
}

