package org.lsst.ccs.plugin.jas3.preferences;

import javax.swing.SwingUtilities;
import org.lsst.ccs.plugin.jas3.preferences.JmsPreferences;
import org.lsst.ccs.plugin.jas3.preferences.RestPreferences;

/**
 *
 * @author tonyj
 */
public class ServersPreferencesPanel extends javax.swing.JPanel {

    JmsPreferences jmsPrefs = new JmsPreferences();
    RestPreferences restPrefs = new RestPreferences();

    /** Creates new form PreferencesPanel */
    public ServersPreferencesPanel() {
        initComponents();
        jmsServerText.setText(jmsPrefs.getJmsServer());
        jmsPortText.setText(jmsPrefs.getJmsPort());
        restServerText.setText(restPrefs.getRestServer());
        restPortText.setText(restPrefs.getRestPort());
    }

    public JmsPreferences getJmsPreferences() {
        return jmsPrefs;
    }

    public RestPreferences getRestPreferences() {
        return restPrefs;
    }

    public void enableJmsPreferences(boolean enable) {
        SwingUtilities.invokeLater(new EnableJmsPreferences(enable));
    }

    public void enableRestPreferences(boolean enable) {
        SwingUtilities.invokeLater(new EnableRestPreferences(enable));
    }

    public void apply() {
        jmsPrefs.setJmsPort(jmsPortText.getText());
        jmsPrefs.setJmsServer(jmsServerText.getText());
        restPrefs.setRestPort(restPortText.getText());
        restPrefs.setRestServer(restServerText.getText());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jmsServerLabel = new javax.swing.JLabel();
        jmsServerText = new javax.swing.JTextField();
        jmlPortLabel = new javax.swing.JLabel();
        jmsPortText = new javax.swing.JTextField();
        restServerLabel = new javax.swing.JLabel();
        restPortLabel = new javax.swing.JLabel();
        restServerText = new javax.swing.JTextField();
        restPortText = new javax.swing.JTextField();

        jmsServerLabel.setText("JMS server");

        jmsServerText.setText("jTextField1");

        jmlPortLabel.setText("JMS port");

        jmsPortText.setText("jTextField2");

        restServerLabel.setText("Rest server");

        restPortLabel.setText("Rest port");

        restServerText.setText("jTextField3");

        restPortText.setText("jTextField4");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(50, 50, 50)
                        .addComponent(jmsServerLabel)
                        .addGap(7, 7, 7)
                        .addComponent(jmsServerText, javax.swing.GroupLayout.PREFERRED_SIZE, 154, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(50, 50, 50)
                        .addComponent(jmlPortLabel)
                        .addGap(18, 18, 18)
                        .addComponent(jmsPortText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(50, 50, 50)
                        .addComponent(restServerLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(restServerText))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(50, 50, 50)
                        .addComponent(restPortLabel)
                        .addGap(15, 15, 15)
                        .addComponent(restPortText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(136, 136, 136))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(20, 20, 20)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jmsServerLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jmsServerText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(10, 10, 10)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jmlPortLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jmsPortText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(10, 10, 10)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(restServerLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(restServerText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(10, 10, 10)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(restPortLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(restPortText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(30, 30, 30))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jmlPortLabel;
    private javax.swing.JTextField jmsPortText;
    private javax.swing.JLabel jmsServerLabel;
    private javax.swing.JTextField jmsServerText;
    private javax.swing.JLabel restPortLabel;
    private javax.swing.JTextField restPortText;
    private javax.swing.JLabel restServerLabel;
    private javax.swing.JTextField restServerText;
    // End of variables declaration//GEN-END:variables

    class EnableJmsPreferences implements Runnable {

        boolean enable;

        EnableJmsPreferences(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void run() {
            jmsServerText.setEditable(enable);
            jmsPortText.setEditable(enable);

        }
    }

    class EnableRestPreferences implements Runnable {

        boolean enable;

        EnableRestPreferences(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void run() {
            restServerText.setEditable(enable);
            restPortText.setEditable(enable);

        }
    }
}
