/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.plugin.jas3.preferences;

import org.freehep.application.studio.Studio;

/**
 *
 * @author turri
 */
public class JmsPreferences {

    private String server, port;
    boolean hasBusesInformationChanged = false;

    public JmsPreferences() {
        server = ((Studio) Studio.getApplication()).getUserProperties().getProperty("org.lsst.jms.server", "localhost");
        port = ((Studio) Studio.getApplication()).getUserProperties().getProperty("org.lsst.jms.port", "3700");
    }

    public String getJmsPort() {
        return port;
    }

    public String getJmsServer() {
        return server;
    }

    public void setJmsPort(String port) {
        if (!this.server.equals(server)) {
            hasBusesInformationChanged = true;
            this.port = port;
            ((Studio) Studio.getApplication()).getUserProperties().setProperty("org.lsst.jms.port", port);
        }
    }

    public void setJmsServer(String server) {
        if (!this.server.equals(server)) {
            hasBusesInformationChanged = true;
            this.server = server;
            ((Studio) Studio.getApplication()).getUserProperties().setProperty("org.lsst.jms.server", server);
        }
    }
    
    public boolean getHasChanged() {
        return hasBusesInformationChanged;
    }
    
    public void reset() {
        hasBusesInformationChanged = false;
    }
}
