package org.lsst.ccs.plugin.jas3;

import java.io.PrintWriter;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandReply;

class Tracer extends Subsystem {

    private final PrintWriter out;
    private String selector = "";

    Tracer(String name, String selector, PrintWriter out) {
        
        //There seeems to be a problem with "setName" will have to get back to it
//        setName(name);
        this.out = out;
        if ( selector != null )
            this.selector = selector;
    }

//    @Override
    protected String getSelector() {
        return selector ;
    }

    @Override
    public void onStatus(BusMessage s) {
        out.println(s);
    }

    
    @Override
    public void onCommand(Command cmd) {
        out.println(cmd + " correl(" + cmd.getCorrelId() + ")");
    }

    @Override
    public void onReply(CommandReply cmd) {
        out.println(cmd + " correl(" + cmd.getCorrelId() + ")");
    }
}
