/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.plugin.jas3;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.util.FreeHEPLookup;

/**
 *
 * @author turri
 */
public abstract class LsstSubsystemPlugin extends Plugin {

    public static Hashtable<String,Tracer> tracersMap = new Hashtable<String,Tracer>();
    
    public abstract void connectToMessagingFactory();
    public abstract void disconnectFromMessagingFactory();
    
    public abstract void initializeRestServices();
    public abstract void resetRestServices();

    public static void registerChannelsForSubsystem(String subsystem) {
        final Studio studio = (Studio) Studio.getApplication();
        LsstPlugin lsstPlugin = (LsstPlugin)studio.getLookup().lookup(LsstPlugin.class);
        lsstPlugin.registerChannelsForSubsystem(subsystem);
    }

    public static void removeChannelsForSubsystem(String subsystem) {
        final Studio studio = (Studio) Studio.getApplication();
        LsstPlugin lsstPlugin = (LsstPlugin)studio.getLookup().lookup(LsstPlugin.class);
        lsstPlugin.removeChannelsForSubsystem(subsystem);
    }

    public static Console createTracerConsole(String name, String selector) {
        if ( tracersMap.containsKey(name) )
            throw new RuntimeException("Tracer with name : "+name+" already exists ");
        final Studio studio = (Studio) Studio.getApplication();
        try {
            FreeHEPLookup lookup = studio.getLookup();
            ConsoleService cs = (ConsoleService) lookup.lookup(ConsoleService.class);
            if (cs != null) {
                Console console = cs.createConsole(name, null);
                ConsoleOutputStream out = console.getOutputStream(null);
                PrintWriter pw = new PrintWriter(out, true);
                final Tracer tracer = new Tracer(name, selector, pw);
                tracersMap.put(name, tracer);
                tracer.setName(name);
                Thread t = new Thread() {

                    public void run() {
                        try {
                            tracer.setListenToStatus(true);
                            tracer.setStatusBroadcastPeriod(0);
                            tracer.start();
                        } catch (Exception e) {
                            studio.error("Problem when connecting to the buses", e);
                        }
                    }
                };
                t.start();
                return console;
            }
        } catch (Exception e) {
            studio.error("Failed to start Tracer: " + name, e);
        }
        return null;
    }

    public static Console createCommandConsole(String name) {
        final Studio studio = (Studio) Studio.getApplication();
        try {
            FreeHEPLookup lookup = studio.getLookup();
            ConsoleService cs = (ConsoleService) lookup.lookup(ConsoleService.class);
            if (cs != null) {
                Console console = cs.createConsole(name, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(console.getInputStream("console>")));
                ConsoleOutputStream out = console.getOutputStream(null);
                PrintWriter pw = new PrintWriter(out, true);
                final CommandConsole command = new CommandConsole(in, pw, name);
                Thread t = new Thread() {

                    public void run() {
                        command.start();
                    }
                };
                t.start();
                return console;
            }
        } catch (Exception e) {
            studio.error("Failed to start Console: " + name, e);
        }
        return null;
    }

    public static void closeTracerConsole(String name) {
        closeConsole(name);
    }

    public static void closeCommandConsole(String name) {
        closeConsole(name);
    }

    private static void closeConsole(String name) {
        Tracer t = tracersMap.remove(name);
        if ( t != null )
            t.shutdown();
        final Studio studio = (Studio) Studio.getApplication();
        ConsoleService cs = (ConsoleService) studio.getLookup().lookup(ConsoleService.class);
        if (cs != null) {
            Console console = cs.getConsole(name);
            if (console != null) {
                console.close();
            }
        }

    }
}
