package org.lsst.ccs.plugin.jas3;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.bus.locking.LockArbitrator.LockOwnerInfo;
import org.lsst.ccs.localdb.data.DummyTestData;

public class DummySubsystem extends Subsystem {
	protected static Logger log = Logger
			.getLogger("lsst.ccs.test.DummySubsystem");

	public static void main(String[] args) {
		System.out.println("log4j config = "+System.getProperty("log4j.configuration"));
		DummySubsystem s = new DummySubsystem();
		log.info("dummy subsystem created, will start");
		System.out.println("dummy subsystem created, will start");
		s.start();
	}

	public DummySubsystem() {
		setName("dummy");
	}

	@Override
	public void addLock(String target, LockOwnerInfo info) {
		log.info("dummy locked " + info);
		super.addLock(target, info);
	}

	@Override
	public void removeLock(String target) {
		log.info("dummy unlocked from " + locks.get(target));
		super.removeLock(target);
	}

	// commands
	public static class DummyCommand extends Command {

		/**
		 * 
		 */
		private static final long serialVersionUID = -7319376291793709178L;

		public DummyCommand(String data) {
			this.data = data;
		}

		String data;

		@Override
		public Object execute(Subsystem s) {
			StringBuilder b = new StringBuilder("Dummy command ");
			b.append(data);
			b.append(" executed from ");
			b.append(getOrigin());
			b.append(" to ");
			b.append(getDestination());
			b.append('/');
			b.append(getKey());
			log.info(b);
			((DummySubsystem) s).sleep(5);
			return null;
		}
	}

	@Override
	public void doStart() {
		new Thread() {
			@Override
			public void run() {
				while (true) {
					log.info("dummy publishing");
					publishData("singledata", 12);
					List<ValueNotification> l = new ArrayList<ValueNotification>();
					l.add(new ValueNotification("data1", 1));
					l.add(new ValueNotification("data2", 2));
					publishData(l);

					publishData("struct", new DummyTestData("toto", 3, 2.4));

					try {
						Thread.sleep(1000);
					} catch (InterruptedException e) {
						// ignore
					}
				}
			}
		}.start();
	}

	public void sleep(int sec) {
		System.out.println("*** SLEEPING " + sec);
		try {
			Thread.sleep(sec * 1000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
