package org.lsst.ccs.plugin.jas3;

import java.io.BufferedReader;
import java.io.IOException;

import java.io.PrintWriter;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleConfigCommand;
import org.lsst.ccs.bus.ModuleInvokerCommand;

public class CommandConsole extends BusMaster {

    private BufferedReader rdr;
    private PrintWriter pw;

    CommandConsole(BufferedReader rdr, PrintWriter pw, String name) {
        this.rdr = rdr;
        this.pw = pw;

        setName(name);
        setStatusBroadcastPeriod(0);
    }

    @Override
    public void doStart() {
        pw.println("Console ready, locking key = " + fac.getToken());
        while (true) {
            try {
                String line = rdr.readLine();
                if (line != null) execute(line);
            } catch (IOException e) {
                pw.println(e);
            }
        }
    }

    public void execute(String line) {
        String[] words = line.split(" +");
        if (words.length < 1) {
            return;
        }
        if (words[0].equals("lock")) {
            executeLock(words);
        } else if (words[0].equals("unlock")) {
            executeUnlock(words);
        } else if (words[0].equals("send")) {
            executeSend(words);
        } else if (words[0].equals("config")) {
            executeConfig(words);
        } else if (words[0].equals("invoke")) {
            executeInvoke(words);
        } else {
            pw.println("unknown command " + words[0]);
            return;
        }
    }

    private void executeSend(String[] words) {
        if (words.length < 3) {
            pw.println("missing arguments to send (target, data)");
        } else {
            String dest = words[1];
            String data = words[2];
            Command cmd = new DummySubsystem.DummyCommand(data);
            cmd.setDestination(dest);
            fac.sendCommand(cmd);
        }

    }

    private Object parse(String s) {
        if (s.matches("-?[0-9]+")) {
            return Integer.parseInt(s);
        } else if (s.matches("-?[0-9]*.[0-9]*|-?[0-9]*.[0-9]*e-?[0-9]+")) {
            return Double.parseDouble(s);
        } else {
            return s;
        }
    }

    private void executeConfig(String[] words) {
        if (words.length < 4) {
            pw.println("missing arguments to config (target, name, value)");
        } else {
            String dest = words[1];
            String name = words[2];
            Object value = parse(words[3]);

            ModuleConfigCommand cmd = new ModuleConfigCommand();
            cmd.put(name, value);
            cmd.setDestination(dest);
            fac.sendCommand(cmd);
        }
    }

    private void executeInvoke(String[] words) {
        if (words.length < 3) {
            pw.println("missing arguments to config (target, name, [params...])");
        } else {
            String dest = words[1];
            String name = words[2];
            int n = words.length - 3;
            Object[] p = new Object[n];
            for (int i = 0; i < n; i++) {
                p[i] = parse(words[3 + i]);
            }

            ModuleInvokerCommand cmd = new ModuleInvokerCommand(name, p);
            cmd.setDestination(dest);
            fac.sendCommand(cmd);
        }
    }

    private void executeLock(String[] words) {
        if (words.length < 2) {
            pw.println("missing argument to lock");
        } else {
            lockSubsystem(words[1]);
        }
    }

    private void executeUnlock(String[] words) {
        if (words.length < 2) {
            pw.println("missing argument to unlock");
        } else {
            unlockSubsystem(words[1]);
        }

    }

	@Override
	public void onReply(CommandReply cmd) {
		String rep = "\nReply message from " + cmd.getOrigin();
		rep += "\nOriginalCommand: " + cmd.getOriginalCommand();
		rep += "\nStatus         : " + cmd.getStatus();
		rep += "\nReply          : " + cmd.getReply();
		// rep += "\nCorrelId       : "+cmd.getCorrelId();
		pw.println(rep);
	}

	@Override
	public void onAck(CommandAck cmd) {
		String rep = "\nAck message from " + cmd.getOrigin();
		rep += "\nOriginalCommand: " + cmd.getOriginalCommand();
		// rep += "\nCorrelId       : "+cmd.getCorrelId();
		pw.println(rep);
	}

    
    
}
