package org.lsst.ccs.gconsole.annotations.processing.persist;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;

/**
 * Annotation processor that generates a list of factories to be used by the persistence service.
 *
 * @author onoprien
 */
@SupportedAnnotationTypes("org.lsst.ccs.gconsole.annotations.services.persist.Create")
@SupportedSourceVersion(SourceVersion.RELEASE_8)
public class CreatorsGenerator extends AbstractProcessor {

// -- Fields : -----------------------------------------------------------------
    
// -- Processor : --------------------------------------------------------------

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {

        ArrayList<String> data = new ArrayList<>();        
        
        for (Element e : roundEnv.getElementsAnnotatedWith(Create.class)) {
            if (e.getKind().equals(ElementKind.METHOD) || e.getKind().equals(ElementKind.CONSTRUCTOR)) {
                Element parent = e.getEnclosingElement();
                if (parent != null && (parent.getKind().isClass() || parent.getKind().isInterface())) {
                    try {
                        TypeElement clazz = (TypeElement) parent;
                        String className = clazz.getQualifiedName().toString();
                        if (className != null && !className.isEmpty() && !data.contains(className)) {
                            data.add(className);
                        }
                    } catch (ClassCastException x) {
                    }
                }
            }
        }
        
        if (! data.isEmpty() ) {
            try (
                 OutputStream os = processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", Create.RESOURCE).openOutputStream();
                 PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
                )
            {
                data.forEach(s -> out.println(s));
            } catch (IOException x) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error writing "+ Create.RESOURCE +": " + x);
            }
        }
        
        return true;
    }
    
}
