package org.lsst.ccs.gconsole.annotations.processing;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;

/**
 * Annotation processor that generates console lookup entries.
 *
 * @author onoprien
 */
@SupportedAnnotationTypes("org.lsst.ccs.gconsole.annotations.ConsoleLookup")
@SupportedSourceVersion(SourceVersion.RELEASE_8)
public class LookupGenerator extends AbstractProcessor {

// -- Fields : -----------------------------------------------------------------
    
// -- Processor : --------------------------------------------------------------

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {

        ArrayList<String> data = new ArrayList<>();        
        
        for (Element e : roundEnv.getElementsAnnotatedWith(ConsoleLookup.class)) {
            if (e.getKind() == ElementKind.CLASS && e.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
                ConsoleLookup ann = e.getAnnotation(ConsoleLookup.class);
                String id = ann.id();
                if (!id.isEmpty()) {
                    String className = e.asType().toString();
                    data.add(id + "=" + className);
                }
            }
        }
        
        if (! data.isEmpty() ) {
            try (
                 OutputStream os = processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", ConsoleLookup.RESOURCE).openOutputStream();
                 PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
                )
            {
                data.forEach(s -> out.println(s));
            } catch (IOException x) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error writing "+ ConsoleLookup.RESOURCE +": " + x);
            }
        }
        
        return true;
    }
    
}
