package org.lsst.ccs.gconsole.annotations.services.persist;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.lsst.ccs.utilities.conv.TypeUtils;

/**
 * Annotates parameters of instance factories used by the persistence service.
 * Can be used to provide parameter descriptions and default values that will be
 * displayed by {@code FactoryDialog}.
 *
 * @author onoprien
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface Par {
    
    /**
     * Parameter description.
     * @return Parameter description.
     */
    String desc();

    /**
     * Default value of the parameter.
     * @return String representation of the default value.
     */
    String def() default NODEF;
    
    /** String that indicates absence of default value. */
    String NODEF = "_nodef_";
    /** String that represents {@code null} default value. */
    String NULL = TypeUtils.NULL_STR;
}
