package org.lsst.ccs.gconsole.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation used to describe a type.
 * The information is intended to be used by GUI components.
 *
 * @author onoprien
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ConsoleLookup {
    String id() default "";
    String name() default "";
    String path() default "";
    String description() default "";
    
    static final String RESOURCE = "gui/lookup.txt";
}
