package org.lsst.ccs.utilities.dispatch;

/**
 * This marker interface is used to specify that implementers of the code
 * executing the command explicitly acknowledge that the caller is waiting for completion of the command.
 * <P>
 * A dispatcher of commands (such as an Observable object)  should not block
 * while waiting for the completion of the command. So the code executed should terminate as quickly as possible.
 *
 * @author bernard Amade
 */
public interface SynchronousCommandFor<T> extends CommandFor<T> {
}
