/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;
import org.lsst.ccs.utilities.beanutils.Optional;
import org.lsst.ccs.utilities.tracers.Tracer;

public class LogPropertiesLoader {
    public static final String LOG_PROPS = "/logging.properties";
    public static final String LOG_CONF_FILE = System.getProperty("java.util.logging.config.file", "/logging.properties");
    static LogManager systemLoaderLogManager;
    Properties loggingProperties;

    public LogPropertiesLoader() {
        systemLoaderLogManager = LogManager.getLogManager();
        this.readInitialConfiguration();
    }

    public static Optional<LogManager> getSystemLoaderLogManager() {
        Optional<LogManager> res = Optional.empty();
        try {
            if (systemLoaderLogManager == null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("org.lsst.ccs.utilities.logging.LogPropertiesLoader");
                clazz.newInstance();
            }
        }
        catch (Exception exc) {
            System.err.println(" ERROR " + exc);
        }
        res = Optional.ofNullable(systemLoaderLogManager);
        return res;
    }

    void readInitialConfiguration() {
        String resourceName = LOG_CONF_FILE;
        String dummyCheckProperty = "ccsLoaded";
        if (systemLoaderLogManager.getProperty(dummyCheckProperty) != null) {
            return;
        }
        this.loggingProperties = ResourcesUtils.getFlatPropertiesObject((Properties)BootstrapResourceUtils.getBootstrapProperties((String)resourceName, this.getClass()));
        this.loggingProperties.setProperty(dummyCheckProperty, "true");
        assert (Tracer.trace(this.loggingProperties.toString()));
        Set<String> set = this.loggingProperties.stringPropertyNames();
        for (String key : set) {
            if (!key.endsWith(".pattern")) continue;
            String pattern = this.loggingProperties.getProperty(key);
            try {
                pattern = this.checkForFile(pattern);
                this.loggingProperties.put(key, pattern);
            }
            catch (IOException e) {
                System.err.println("problem while creating log directory " + e);
            }
            break;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.loggingProperties.store(bos, "");
            byte[] bytes = bos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            systemLoaderLogManager.readConfiguration(bis);
            this.handlersLazyLoad();
        }
        catch (IOException e) {
            System.err.println(" can't load properties for LogManager" + e);
        }
    }

    protected void handlersLazyLoad() throws IOException {
        Enumeration<String> loggerNames = systemLoaderLogManager.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            Logger logger = systemLoaderLogManager.getLogger(loggerName);
            if (logger == null) continue;
            this.loadLoggerHandlers(loggerName, logger);
        }
    }

    protected void loadLoggerHandlers(String loggerName, Logger logger) throws IOException {
        Handler[] logHandlers = logger.getHandlers();
        HashSet<String> currentHandlersNames = new HashSet<String>();
        Handler[] handlerArray = logHandlers;
        int n = logHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            currentHandlersNames.add(handler.getClass().getName());
            ++n2;
        }
        String handlers = this.loggingProperties.getProperty(String.valueOf(loggerName) + ".handlersN");
        if (handlers == null && "".equals(loggerName)) {
            handlers = this.loggingProperties.getProperty("handlersN");
        }
        if (handlers != null) {
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                int pos;
                String handlerName = tok.nextToken().trim();
                String handlerClassName = handlerName;
                if (handlerClassName.length() <= 0) continue;
                if (Character.isDigit(handlerClassName.charAt(0)) && (pos = handlerClassName.indexOf(46)) >= 0) {
                    handlerClassName.substring(0, pos + 1);
                    handlerClassName = handlerClassName.substring(pos + 1);
                }
                if (currentHandlersNames.contains(handlerClassName)) continue;
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Handler handler = (Handler)classLoader.loadClass(handlerClassName).newInstance();
                    this.configureHandler(handlerName, handler);
                    logger.addHandler(handler);
                }
                catch (Exception e) {
                    System.err.println("Handler error");
                    e.printStackTrace();
                }
            }
        }
        this.setLevelOnExistingLogger(loggerName, logger);
    }

    protected void configureHandler(String handlerName, Handler handler) {
        Level level = this.getLevelProperty(String.valueOf(handlerName) + ".level", null);
        if (level == null) {
            level = this.getLevelProperty(".level", Level.OFF);
        }
        handler.setLevel(level);
        Filter filter = this.getFilterProperty(String.valueOf(handlerName) + ".filter", null);
        if (filter == null) {
            filter = this.getFilterProperty(".filter", null);
        }
        if (filter != null) {
            handler.setFilter(filter);
        }
        Formatter formatter = this.getFormatterProperty(String.valueOf(handlerName) + ".formatter", new SimpleFormatter());
        handler.setFormatter(formatter);
    }

    protected String replace(String str, Properties props) {
        String propName;
        String replacement;
        int pos_end;
        String result = str;
        int pos_start = result.indexOf("${");
        if (pos_start != -1 && (pos_end = result.indexOf(125)) != -1 && (replacement = props.getProperty(propName = result.substring(pos_start + 2, pos_end))) != null) {
            result = pos_start > 0 ? String.valueOf(result.substring(0, pos_start)) + replacement + this.replace(result.substring(pos_end + 1), props) : String.valueOf(replacement) + this.replace(result.substring(pos_end + 1), props);
        }
        return result;
    }

    String checkForFile(String filePattern) throws IOException {
        int lastSlash;
        String logdir;
        Properties bootstrapSystemProperties = BootstrapResourceUtils.getBootstrapSystemProperties();
        if (filePattern.contains("%W")) {
            logdir = bootstrapSystemProperties.getProperty("org.lsst.ccs.workdir", "%h");
            filePattern = filePattern.replace("%W", logdir);
        }
        if (filePattern.contains("%L")) {
            logdir = bootstrapSystemProperties.getProperty("org.lsst.ccs.logdir", "%h");
            filePattern = filePattern.replace("%L", logdir);
        }
        if (filePattern.contains("%A")) {
            String applicationName = bootstrapSystemProperties.getProperty("org.lsst.ccs.application.name", "%u");
            filePattern = filePattern.replace("%A", applicationName);
        }
        if ((lastSlash = filePattern.lastIndexOf(47)) >= 0) {
            String directorySpec = filePattern.substring(0, lastSlash);
            if (directorySpec.contains("%h")) {
                directorySpec = directorySpec.replace("%h", System.getProperty("user.home"));
            } else if (directorySpec.contains("%t")) {
                directorySpec = directorySpec.replace("%t", System.getProperty("java.io.tmpdir"));
            }
            Files.createDirectories(FileSystems.getDefault().getPath(directorySpec, new String[0]), new FileAttribute[0]);
        }
        return filePattern;
    }

    public static String loaderGetProperty(String name) {
        LogPropertiesLoader.getSystemLoaderLogManager();
        try {
            String res = systemLoaderLogManager.getProperty(name);
            return res;
        }
        catch (Exception e) {
            System.err.println(" loaderGetProperty :" + e);
            return null;
        }
    }

    public static String loaderGetStringProperty(String name, String defaultValue) {
        String val = LogPropertiesLoader.loaderGetProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    public static int loaderGetIntProperty(String name, int defaultValue) {
        String val = LogPropertiesLoader.loaderGetProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static Level loaderGetLevelProperty(String name, Level defaultValue) {
        String val = LogPropertiesLoader.loaderGetProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static Formatter loaderGetFormatterProperty(String name, Formatter defaultValue) {
        String val = LogPropertiesLoader.loaderGetProperty(name);
        try {
            if (val != null) {
                Class<?> clazz = LogPropertiesLoader.class.getClassLoader().loadClass(val);
                return (Formatter)clazz.newInstance();
            }
        }
        catch (Exception exception) {}
        return defaultValue;
    }

    private synchronized void setLevelOnExistingLogger(String loggerName, Logger logger) {
        Level level = this.getLevelProperty(String.valueOf(loggerName) + ".level", null);
        if (level != null) {
            logger.setLevel(level);
        }
    }

    public String getProperty(String property) {
        return systemLoaderLogManager.getProperty(property);
    }

    public String getStringProperty(String name, String defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    public int getIntProperty(String name, int defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    public Level getLevelProperty(String name, Level defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public Filter getFilterProperty(String name, Filter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {}
        return defaultValue;
    }

    public Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {}
        return defaultValue;
    }
}

