/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.utilities.zonesui;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;

/**
 *
 * @author Pascal Durieu
 */
public class ZonesPanel extends JPanel implements PositionListener{
    private ImageZones imgZones ;
    private JLabel markCoords = new JLabel("        ", JLabel.CENTER);

    public ZonesPanel(ImageDescription id, InteractionProducer ip) {
        imgZones = new ImageZones(id, ip, this);
        setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(imgZones, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        this.add(scroll) ;
        this.add(markCoords, BorderLayout.PAGE_START);
    }
    @Override
    public Dimension getPreferredSize() {
        Dimension tailleEcran = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        Dimension tailleImage = imgZones.getPreferredSize();
        if ((tailleImage.getHeight() < tailleEcran.getHeight()) && (tailleImage.getWidth() < tailleEcran.getWidth())) {
            int labelHeight = markCoords.getHeight();
           tailleImage.setSize(tailleImage.width, labelHeight + tailleImage.height);
            //TODO: add the scrollbars height and width
            return tailleImage;
        }
        else
            return tailleEcran;
    //return imgZones.getPreferredSize();
    }
    @Override
    public Dimension getMinimumSize() {
        int labelHeight = markCoords.getHeight();
        Dimension dims = imgZones.getMinimumSize() ;
        dims.setSize( dims.width, labelHeight + dims.height);
        //TODO: add the scrollbars height and width
        return dims ;
    }

    @Override
    public void currentCoords(int x, int y) {
        markCoords.setText("(" + x + "," + y + ")");
    }

    public void setStroke(Stroke stroke) {
        imgZones.setStroke(stroke);
    }

    public void setDashedLineColor(Color color) {
        imgZones.setDashedLineColor(color);
    }

    public void setDashedLineWidth(int points) {
        imgZones.setDashedLineWidth(points);
    }
}
