package org.lsst.ccs.utilities.dsp;

/**
 * 
 * @author aubourg
 * 
 */
public class FIRFilter implements DigitalFilter {
	/**
	 * 
	 */
	private static final long serialVersionUID = 2786444222861355300L;

	double rate; // Hz

	int order;

	double[] history;

	int ip; // last point in history

	double[] aCoeff;

	protected FIRFilter(double[] coeff) {
		aCoeff = coeff;
		order = coeff.length - 1;
		history = new double[order + 1];
		ip = 0;
	}

	public void reset() {
		for (int i = 0; i <= order; i++) {
			history[i] = 0;
		}
		ip = 0;
	}

	public double getRate() {
		return rate;
	}

	public int getDelay() {
		return (order) / 2;
	}

	public double flush() {
		return apply(0);
	}

	public double apply(double signal) {
		ip++;
		if (ip >= order) {
			ip = 0;
		}
		history[ip] = signal;
		double resp = 0;
		for (int i = 0; i <= order; i++) {
			int j = (ip - i) % (order + 1);
			if (j < 0) {
				j += order + 1;
			}
			// System.out.println("apply "+i+" "+j+" "+aCoeff[i]+"
			// "+history[j]+" "+(aCoeff[i] * history[j]));
			resp += aCoeff[i] * history[j];
		}
		return resp;
	}

	public double freqResp(double freq) {
		// TODO Auto-generated method stub
		return 0;
	}

	public int getOrder() {
		return order;
	}

	public void print() {
		System.out.println("FIRFilter order " + order);
		for (int i = 0; i <= order; i++) {
			System.out.println("  a[" + i + "] = " + aCoeff[i]);
		}
		System.out.println("---");
	}

	@Override
	public Object clone() {
		try {
			FIRFilter f = (FIRFilter) super.clone();
			f.history = new double[order + 1];
			return f;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}
