package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.subsystem.vacuum.constants.Devices;

/**
 * Device class which simulates VacMksDevice
 * 
 * @author CCS team
 */
public class VacSimMksDevice  extends SimMks9xxDevice implements SwitchDevice {

    private int deviceId = Devices.DEVC_NO_SWITCH;  // Set in Groovy file

    private boolean isOn = false;

    /**
     *  Gets the switch device ID.
     * 
     *  @return  The device ID
     */
    @Override
    public int getSwitchDevice()
    {
        return deviceId;
    }


    /**
     *  Turns a switch on or off.
     * 
     *  @param  sw  The switch ID
     *  @param  on  Whether to turn on or off
     */
    @Override
    public void setSwitch(int sw, boolean on)
    {
        isOn = on;
    }


    /**
     *  Gets whether a switch is on.
     * 
     *  @param  sw  The switch ID
     *  @return  Whether on, or null if device is offline
     */
    @Override
    public Boolean isSwitchOn(int sw)
    {
        return isOn;
    }
    
}
