/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.vacuum.data.VacuumException;

public class Switches {
    public static final int SW_CRYO_TURBO_PUMP = 0;
    public static final int SW_CRYO_ION_PUMP1 = 1;
    public static final int SW_CRYO_ION_PUMP2 = 2;
    public static final int SW_CRYO_ION_PUMP3 = 3;
    public static final int SW_CRYO_ION_PUMP4 = 4;
    public static final int SW_CRYO_ION_PUMP5 = 5;
    public static final int SW_CRYO_ION_PUMP6 = 6;
    public static final int SW_CRYO_GATE_VALVE = 7;
    public static final int SW_CRYO_SCROLL_PUMP = 8;
    public static final int SW_HX_TURBO_PUMP = 9;
    public static final int SW_HX_ION_PUMP1 = 10;
    public static final int SW_HX_ION_PUMP2 = 11;
    public static final int SW_HX_GATE_VALVE = 12;
    public static final int SW_HX_SCROLL_PUMP = 13;
    public static final int SW_INST_FTPP_VALVE = 14;
    public static final int SW_INST_FTH_VALVE = 15;
    public static final int SW_INST_L3H_VALVE = 16;
    public static final int SW_INST_L3LF_VALVE = 17;
    public static final int SW_INST_SCROLL_PUMP = 18;
    public static final int NUM_SWITCHES = 19;
    private static final Map<String, Integer> nameMap = new LinkedHashMap<String, Integer>();
    private static final Map<Integer, String> idMap;
    private static final int[] deviceList;

    public static List<String> getNames() {
        return new ArrayList<String>(nameMap.keySet());
    }

    public static String getName(int id) {
        return idMap.get(id);
    }

    public static int getId(String name) throws VacuumException {
        Integer id = nameMap.get(name);
        if (id == null) {
            throw new VacuumException("Invalid valve name: " + name);
        }
        return id;
    }

    public static int getDevice(int id) {
        return deviceList[id];
    }

    static {
        nameMap.put("CryoTurboPump", 0);
        nameMap.put("CryoIonPump1", 1);
        nameMap.put("CryoIonPump2", 2);
        nameMap.put("CryoIonPump3", 3);
        nameMap.put("CryoIonPump4", 4);
        nameMap.put("CryoIonPump5", 5);
        nameMap.put("CryoIonPump6", 6);
        nameMap.put("CryoGateValve", 7);
        nameMap.put("CryoScrollPump", 8);
        nameMap.put("HxTurboPump", 9);
        nameMap.put("HxIonPump1", 10);
        nameMap.put("HxIonPump2", 11);
        nameMap.put("HxGateValve", 12);
        nameMap.put("HxScrollPump", 13);
        nameMap.put("InstFppValve", 14);
        nameMap.put("InstFthValve", 15);
        nameMap.put("InstL3hValve", 16);
        nameMap.put("InstL3lfValve", 17);
        nameMap.put("InstScrollPump", 18);
        idMap = new LinkedHashMap<Integer, String>();
        for (Map.Entry<String, Integer> e : nameMap.entrySet()) {
            idMap.put(e.getValue(), e.getKey());
        }
        deviceList = new int[19];
        Switches.deviceList[0] = 2;
        Switches.deviceList[1] = 1;
        Switches.deviceList[2] = 1;
        Switches.deviceList[3] = 1;
        Switches.deviceList[4] = 1;
        Switches.deviceList[5] = 1;
        Switches.deviceList[6] = 1;
        Switches.deviceList[7] = 0;
        Switches.deviceList[8] = 4;
        Switches.deviceList[9] = 3;
        Switches.deviceList[10] = 1;
        Switches.deviceList[11] = 1;
        Switches.deviceList[12] = 0;
        Switches.deviceList[13] = 4;
        Switches.deviceList[14] = 0;
        Switches.deviceList[15] = 0;
        Switches.deviceList[16] = 0;
        Switches.deviceList[17] = 0;
        Switches.deviceList[18] = 4;
    }
}

