/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.Measurement;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.twistorr.TwisTorr;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.common.actions.RefrigAction;
import org.lsst.ccs.subsystem.common.switches.SwitchesOnOffCustomLevels;
import org.lsst.ccs.subsystem.power.data.QuadBoxState;
import org.lsst.ccs.subsystem.vacuum.ASM380Device;
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchInfo;
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice;
import org.lsst.ccs.subsystem.vacuum.VacTurboDevice;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.CryoVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.Devices;
import org.lsst.ccs.subsystem.vacuum.constants.HxVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.constants.VacuumAlert;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;
import org.lsst.ccs.subsystem.vacuum.data.VacuumException;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class VacuumMain
extends Subsystem
implements HasLifecycle,
AlertListener,
AgentPresenceListener,
StatusMessageListener {
    volatile QuadBoxState qbs = null;
    private static final double PRESS_ATMOS = 759.0;
    private static final double SPEED_CRYO_TURBO_MAX = 60000.0;
    private static final double SPEED_HX_TURBO_MAX = 81000.0;
    private static final double PUMPCART_RESPONSE_TIME = 2.0;
    private static final int MAX_PRESS_ERRORS = 2;
    private static final int MAX_SPEED_ERRORS = 0;
    private static final int MAX_TEMP_ERRORS = 0;
    private static final int MAX_POWER_ERRORS = 0;
    private static final int MAX_AIR_ERRORS = 0;
    private static final int DELAY_ION_OFF = 10000;
    private static final int DELAY_VACUUM_BAD = 10000;
    private static final int MAX_PCPUMP_ERRORS = 2;
    private static final int MAX_UNPUBLISH_TIME = 10000;
    private int turboFailureCode = TwisTorr.PumpStatus.FAIL.ordinal();
    private boolean testingModeOn = false;
    private static final Map<Integer, VacuumAlert> latchAlertMap = new HashMap<Integer, VacuumAlert>();
    private static final Map<String, Integer> revLatchAlertMap;
    private static final List<Integer> cryoIonPumps;
    private static final List<Integer> hxIonPumps;
    private static final List<Integer> utSwitches;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService aps;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ASM380Device pumpCartDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<SwitchDevice> switchDevcs = new ArrayList<SwitchDevice>();
    private Channel cryoVacPressure;
    private Channel cryoTurboPressure;
    private Channel cryoTurboTemp;
    private Channel cryoTurboPower;
    private Channel cryoFlinePressure;
    private Channel cryoTurboSpeed;
    private Channel cryoTurboStatus;
    private Channel hxVacPressure;
    private Channel hxTurboPressure;
    private Channel hxTurboTemp;
    private Channel hxTurboPower;
    private Channel hxFlinePressure;
    private Channel hxTurboSpeed;
    private Channel hxTurboStatus;
    private Channel airPressure;
    private Channel pcCyclingStatusChan;
    private Channel pcVentingStatusChan;
    private Channel cryoFlineValveStatusChan;
    private Channel hxFlineValveStatusChan;
    private Channel pcInletPressureChan;
    @ConfigurationParameter(isFinal=true, description="Switches Custom Levels", units="unitless")
    SwitchesOnOffCustomLevels switchesCustomLevels = new SwitchesOnOffCustomLevels();
    @ConfigurationParameter(category="Vacuum", isFinal=false, units="Torr", description="cryostat pressure change pumpcart panel update trigger")
    private volatile double pChangeStateUpdate = 0.1;
    @ConfigurationParameter(category="Vacuum", isFinal=false, units="Torr", description="foreline pressure change pumpcart panel update trigger")
    private volatile double pFLChangeStateUpdate = 1.0;
    @ConfigurationParameter(category="Vacuum", isFinal=false, units="Torr", description="pumpcart pressure change pumpcart panel update trigger")
    private volatile double pPCChangeStateUpdate = 0.5;
    @ConfigurationParameter(category="Vacuum", isFinal=false, units="Torr", description="floor value for the allowable difference btwn the foreline and the PC inlet pressure")
    private volatile double pcPdiffFloor = 5.0E-5;
    @ConfigurationParameter(category="Vacuum", isFinal=false, units="unitless", description="scale value for the allowable difference btwn the foreline and the PC inlet pressure")
    private volatile double pcPdiffScaleFactor = 0.026;
    @ConfigurationParameter(category="Vacuum", isFinal=true, range="0.0..1.0e-4", units="Torr", description="floor value for the allowed cryostat-foreline pressure difference")
    private volatile double cryoPdiffFloor = 1.0E-4;
    @ConfigurationParameter(category="Vacuum", isFinal=true, range="0.95..1.0", units="unitless", description="scale for the allowed cryostat-foreline pressure difference")
    private volatile double cryoPScale = 0.97;
    @ConfigurationParameter(category="Vacuum", isFinal=true, range="0.0..1.0e-4", units="Torr", description="floor value for the allowed HX-foreline pressure difference")
    private volatile double hxPdiffFloor = 1.0E-4;
    @ConfigurationParameter(category="Vacuum", isFinal=true, range="0.95..1.0", units="unitless", description="scale for the allowed HX-foreline pressure difference")
    private volatile double hxPScale = 0.97;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="0.0..0.5", units="Torr", description="max turbo pressure at which turbo pump is enabled")
    private volatile double pressTurboLow;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="0.0..0.5", units="Torr", description="max foreline pressure at which turbo pump is enabled")
    private volatile double pressForelineLow;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="0.00..0.09", units="Torr", description="max allowed press difference across gate valve")
    private volatile double pressDiffLow;
    @ConfigurationParameter(category="Vacuum", isFinal=true, range="0.1..5.0", units="Torr", description="max allowed press difference across gate valve when turbo not spinning")
    private volatile double pressDiffHighMin;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="1.0e-6..1.1e-5", units="Torr", description="pressure above which the ion pumps are turned off")
    private volatile double pressIonOff;
    @ConfigurationParameter(category="Vacuum", isFinal=true, units="Torr", description="pressure below which the ion pumps are enabled")
    private volatile double pressIonEnable;
    @ConfigurationParameter(category="Vacuum", isFinal=true, units="Torr", description="pressure below which the system considered to be under vacuum and for correspondingly setting the state")
    private volatile double pressVacuum;
    @ConfigurationParameter(category="Vacuum", isFinal=true, units="Torr", description="max pressure for allowing refrigeration to operate")
    private volatile double pressRefrigOk;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="-0.01..0.1", units="unitless", description="fraction of max turbo speed below which the turbo is considered to be not spinning")
    private volatile double speedFractTurboLow;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="6.0e-5..2.55e-4", units="Torr", description="max pressure allowed for enabling the vacuum gauge cold cathode")
    private volatile double pressCCEnable;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="1.2e-5..1.2e-4", units="Torr", description="max pressure allowed for enabling the vacuum gauge cold cathode")
    private volatile double pressCCOff;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="0..300000", units="ms", description="vacuum gauge cold cathode off delay")
    private volatile double delayCCOff;
    @ConfigurationParameter(category="Vacuum", isFinal=true, units="ms", description="max cryo gate transit time between limit switches before declaring a problem")
    private volatile long tranTimeCryoGate;
    @ConfigurationParameter(category="Vacuum", isFinal=true, units="ms", description="max cryo gate transit time between limit switches before declaring a problem")
    private volatile long tranTimeHxGate;
    private static final Logger LOG;
    private double speedCryoTurboLow;
    private double speedHxTurboLow;
    private MonitorTaskControl monitorControl;
    private final SwitchDevice[] switchDevices = new SwitchDevice[10];
    private VacPlutoDevice vacPlutoDevc;
    private IonPumpDevice ionPumpDevc;
    private VacTurboDevice cryoTurboDevc;
    private VacTurboDevice hxTurboDevc;
    private final VacSysState vacState = new VacSysState();
    private final Map<String, Boolean> activeAlarmMap = new HashMap<String, Boolean>();
    private long cryoIonOverStartTime = 0L;
    private long hxIonOverStartTime = 0L;
    private long cryoVacCCOverStartTime = 0L;
    private long hxVacCCOverStartTime = 0L;
    private long cryoTurboCCOverStartTime = 0L;
    private long hxTurboCCOverStartTime = 0L;
    private long vacBadTime = 0L;
    private long lastPublishTime = 0L;
    private SensorData cryoFlinePrs;
    private SensorData cryoMainPrs;
    private SensorData cryoTurboPrs;
    private SensorData cryoTurboSpd;
    private SensorData cryoTurboTmp;
    private SensorData cryoTurboPwr;
    private SensorData cryoTurboStat;
    private SensorData hxFlinePrs;
    private SensorData hxMainPrs;
    private SensorData hxTurboPrs;
    private SensorData hxTurboSpd;
    private SensorData hxTurboTmp;
    private SensorData hxTurboPwr;
    private SensorData hxTurboStat;
    private SensorData cmpAirPrs;
    private SensorData pcCyclingStatus;
    private SensorData pcVentingStatus;
    private SensorData cryoFlineValveStatus;
    private SensorData hxFlineValveStatus;
    private SensorData pcInletPressure;
    private double oldCryoFlinePrs;
    private double oldCryoMainPrs;
    private double oldCryoTurboPrs;
    private double oldHxFlinePrs;
    private double oldHxMainPrs;
    private double oldHxTurboPrs;
    private double oldCmpAirPrs;
    private double oldPCPrs;
    private Map<Integer, Long> gateTransitStart = new HashMap<Integer, Long>();
    private boolean gotCommand = false;
    private int oldPcCycStat;
    private int oldPcVentStat;
    private int oldCryoFlValveStat;
    private int oldhxFlValveStat;

    public void onStatusMessage(StatusMessage msg) {
        try {
            if (msg instanceof StatusSubsystemData) {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                LOG.log(Level.FINE, "onStatusMessage key = QuadBoxState | d.sDataKey = " + sd.getDataKey());
                if (sd.getDataKey().equals("QuadBoxState")) {
                    LOG.log(Level.FINE, "QuadBoxState sd received");
                    this.qbs = (QuadBoxState)sd.getSubsystemData().getValue();
                }
            }
        }
        catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
            // empty catch block
        }
    }

    public VacuumMain() {
        super("vacuum", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("vacuum-state", () -> this.updateVacuumState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        this.stateService.registerState(CryoVacuumState.class, "Cryo vacuum state", (Object)this);
        this.stateService.updateAgentState(new Enum[]{CryoVacuumState.UNKNOWN});
        this.stateService.registerState(HxVacuumState.class, "HX vacuum state", (Object)this);
        this.stateService.updateAgentState(new Enum[]{HxVacuumState.UNKNOWN});
        for (VacuumAlert alert : VacuumAlert.values()) {
            this.activeAlarmMap.put(alert.getId(), false);
        }
    }

    public void init() {
        for (VacuumAlert alert : VacuumAlert.values()) {
            this.alertService.registerAlert(alert.getAlert());
        }
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            LOG.info("agent = " + agent);
            if (!agent.hasAgentProperty("quadBoxAgent")) continue;
            String agentName = agent.getName();
            LOG.info("adding listening for agent = " + agentName);
            ((MessagingService)this.subsys.getAgentService(MessagingService.class)).getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName));
            this.getScheduler().schedule(() -> this.requestQuadboxState(agentName), 0L, TimeUnit.MILLISECONDS);
        }
    }

    private void requestQuadboxState(String quadboxName) {
        CommandRequest cmd = new CommandRequest(quadboxName, "publishFullState");
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.getMessagingAccess());
        try {
            cmu.sendSynchronousCommand(cmd);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to execute command to acquire QuadBoxState", ex);
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("quadBoxAgent")) continue;
            ((MessagingService)this.subsys.getAgentService(MessagingService.class)).getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("vacuumType", VacuumMain.class.getCanonicalName());
        this.aps.setAgentProperty("vacuumAgent", ((Object)((Object)this)).getClass().getCanonicalName());
        ((MessagingService)this.subsys.getAgentService(MessagingService.class)).getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.alertService.addListener((AlertListener)this);
        for (SwitchDevice device : this.switchDevcs) {
            int id = device.getSwitchDevice();
            if (id < -1 || id >= 10) {
                throw new RuntimeException("Device of class " + device.getClass().getSimpleName() + " has invalid id: " + id);
            }
            if (id == -1) continue;
            this.switchDevices[id] = device;
        }
        for (int id = 0; id < 10; ++id) {
            if (this.switchDevices[id] != null) continue;
            throw new RuntimeException(Devices.getDescription((int)id) + " device not defined");
        }
        this.vacPlutoDevc = (VacPlutoDevice)this.switchDevices[0];
        this.ionPumpDevc = (IonPumpDevice)this.switchDevices[1];
        this.cryoTurboDevc = (VacTurboDevice)this.switchDevices[2];
        this.hxTurboDevc = (VacTurboDevice)this.switchDevices[3];
        if (this.pcInletPressureChan == null) {
            throw new RuntimeException("Pump Cart Inlet Pressure channel (pcInletPressureChan) not specified");
        }
        this.pcInletPressure = new SensorData(this.pcInletPressureChan, 2);
        if (this.pcCyclingStatusChan == null) {
            throw new RuntimeException("Pump Cart Cycling Status channel (pcCyclingStatusChan) not specified");
        }
        this.pcCyclingStatus = new SensorData(this.pcCyclingStatusChan, 2);
        if (this.pcVentingStatusChan == null) {
            throw new RuntimeException("Pump Cart Venting Status channel (pcVentingStatusChan) not specified");
        }
        this.pcVentingStatus = new SensorData(this.pcVentingStatusChan, 2);
        if (this.cryoFlineValveStatusChan == null) {
            throw new RuntimeException("Cryo Foreline Valve Limit Switches Status channel (cryoFlineValveStatusChan) not specified");
        }
        this.cryoFlineValveStatus = new SensorData(this.cryoFlineValveStatusChan, 2);
        if (this.hxFlineValveStatusChan == null) {
            throw new RuntimeException("HX Foreline Valve Limit Switches Status channel (hxFlineValveStatusChan) not specified");
        }
        this.hxFlineValveStatus = new SensorData(this.hxFlineValveStatusChan, 2);
        if (this.cryoFlinePressure == null) {
            throw new RuntimeException("Cryo foreline pressure channel (cryoFlinePressure) not specified");
        }
        this.cryoFlinePrs = new SensorData(this.cryoFlinePressure, 2);
        if (this.cryoVacPressure == null) {
            throw new RuntimeException("Cryo vacuum pressure channel (cryoVacPressure) not specified");
        }
        this.cryoMainPrs = new SensorData(this.cryoVacPressure, 2);
        this.ionPumpDevc.setCryoPressureChannel(this.cryoVacPressure);
        if (this.cryoTurboPressure == null) {
            throw new RuntimeException("Cryo turbo pump pressure channel (cryoTurboPressure) not specified");
        }
        this.cryoTurboPrs = new SensorData(this.cryoTurboPressure, 2);
        if (this.cryoTurboSpeed == null) {
            throw new RuntimeException("Cryo turbo pump speed channel (cryoTurboSpeed) not specified");
        }
        this.cryoTurboSpd = new SensorData(this.cryoTurboSpeed, 0);
        if (this.cryoTurboTemp == null) {
            throw new RuntimeException("Cryo turbo pump temperature channel (cryoTurboTemp) not specified");
        }
        this.cryoTurboTmp = new SensorData(this.cryoTurboTemp, 0, true);
        if (this.cryoTurboPower == null) {
            throw new RuntimeException("Cryo turbo pump power channel (cryoTurboPower) not specified");
        }
        this.cryoTurboPwr = new SensorData(this.cryoTurboPower, 0, true);
        if (this.cryoTurboStatus == null) {
            throw new RuntimeException("Cryo turbo pump status channel (cryoTurboStatus) not specified");
        }
        this.cryoTurboStat = new SensorData(this.cryoTurboStatus, 0, true);
        if (this.hxFlinePressure == null) {
            throw new RuntimeException("HX foreline pressure channel (hxFlinePressure) not specified");
        }
        this.hxFlinePrs = new SensorData(this.hxFlinePressure, 2);
        if (this.hxVacPressure == null) {
            throw new RuntimeException("HX vacuum pressure channel (hxVacPressure) not specified");
        }
        this.hxMainPrs = new SensorData(this.hxVacPressure, 2);
        this.ionPumpDevc.setHxPressureChannel(this.hxVacPressure);
        if (this.hxTurboPressure == null) {
            throw new RuntimeException("HX turbo pump pressure channel (hxTurboPressure) not specified");
        }
        this.hxTurboPrs = new SensorData(this.hxTurboPressure, 2);
        if (this.hxTurboSpeed == null) {
            throw new RuntimeException("HX turbo pump speed channel (hxTurboSpeed) not specified");
        }
        this.hxTurboSpd = new SensorData(this.hxTurboSpeed, 0);
        if (this.hxTurboTemp == null) {
            throw new RuntimeException("HX turbo pump temperature channel (hxTurboTemp) not specified");
        }
        this.hxTurboTmp = new SensorData(this.hxTurboTemp, 0, true);
        if (this.hxTurboPower == null) {
            throw new RuntimeException("HX turbo pump power channel (hxTurboPower) not specified");
        }
        this.hxTurboPwr = new SensorData(this.hxTurboPower, 0, true);
        if (this.hxTurboStatus == null) {
            throw new RuntimeException("HX turbo pump status channel (hxTurboStatus) not specified");
        }
        this.hxTurboStat = new SensorData(this.hxTurboStatus, 0, true);
        if (this.airPressure == null) {
            throw new RuntimeException("Compressed air pressure channel (airPressure) not specified");
        }
        this.cmpAirPrs = new SensorData(this.airPressure, 0, true);
        this.speedCryoTurboLow = this.speedFractTurboLow * 60000.0;
        this.speedHxTurboLow = this.speedFractTurboLow * 81000.0;
    }

    public void postStart() {
        LOG.info("Vacuum subsystem started");
    }

    @Command(type=Command.CommandType.QUERY, description="Get the vacuum system state", level=0)
    public VacSysState getVacuumState() {
        this.vacState.setTickMillis(this.monitorControl.getFastPeriod());
        return this.vacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names", level=0)
    public List<String> getSwitchNames() throws VacuumException {
        return Switches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false)
    public void setSwitchOn(@Argument(description="The switch name") String switchName, @Argument(description="Whether to turn on") boolean isOn) throws VacuumException {
        this.helper().precondition(this.switchesCustomLevels.isCommandRequestCompatibleWithCustomLevel((Agent)this, switchName, isOn), "Insufficient lock level for turning the switch %s. Required custom level is: %d", new Object[]{isOn ? "On" : "Off", this.switchesCustomLevels.getCustomLevelForSwitch(switchName, isOn)}).action(() -> {
            this.gotCommand = true;
            this.setSwitch(Switches.getId((String)switchName), isOn);
        });
    }

    @Command(type=Command.CommandType.QUERY, description="Print enable and state for switch")
    public String checkSwitch(@Argument(description="The switch name") String name) throws VacuumException {
        int sw = Switches.getId((String)name);
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        SwitchState state = this.vacState.getSwitchState(sw);
        return "enable=" + enable.name() + ", state=" + state.name();
    }

    private void setSwitch(int sw, boolean on) throws VacuumException {
        SwitchState state = this.vacState.getSwitchState(sw);
        if (state == SwitchState.OFFLINE) {
            return;
        }
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        if (on && enable != SwitchEnable.ON) {
            throw new VacuumException("Cannot turn switch on, the switch is disabled.");
        }
        try {
            LOG.log(Level.INFO, String.format("VacuumMain.setSwitch(%d, %s)", sw, on));
            LOG.log(Level.INFO, String.format("VacuumMain.setSwitch(%s, %s)", Switches.getName((int)sw), on));
            this.switchDevices[Switches.getDevice((int)sw)].setSwitch(SwitchInfo.getSwitch(sw), on);
        }
        catch (DriverException e) {
            throw new VacuumException(String.format("Error setting switch for " + Devices.getDescription((int)Switches.getDevice((int)sw)) + " device: " + e, new Object[0]));
        }
    }

    private Boolean isSwitchOn(int sw) {
        return this.switchDevices[Switches.getDevice((int)sw)].isSwitchOn(SwitchInfo.getSwitch(sw));
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a condition")
    public void clearLatch(@Argument(description="The condition number") int cond) throws VacuumException {
        this.gotCommand = true;
        this.vacPlutoDevc.clearLatch(cond);
    }

    private void updateVacuumState() {
        boolean changed = this.monitorControl.hasPeriodChanged();
        changed |= this.updatePlcState();
        changed |= this.updateLatchState();
        changed |= this.updateCondState();
        if (this.readSensors()) {
            changed |= this.updateForelineState();
            changed |= this.updateSwitchState();
            changed |= this.updateCryoState();
            changed |= this.updateHxState();
            this.checkRefrigVacuum();
        }
        if (this.gotCommand) {
            this.gotCommand = false;
            changed = true;
        }
        if (changed |= System.currentTimeMillis() - this.lastPublishTime >= 10000L) {
            this.publishState();
            this.lastPublishTime = System.currentTimeMillis();
        }
    }

    private boolean updateForelineState() {
        int hxFlValveStat;
        int cryoFlValveStat;
        boolean changed = false;
        this.readSensor(this.pcInletPressure);
        this.readSensor(this.pcCyclingStatus);
        this.readSensor(this.pcVentingStatus);
        this.vacState.setPumpCartPumpingSwitchState(this.pumpCartDevc.getPumpSwitchState());
        this.vacState.setPumpCartVentingSwitchState(this.pumpCartDevc.getVentSwitchState());
        LOG.log(Level.FINE, "Pump switch state - " + this.pumpCartDevc.getPumpSwitchState());
        int pcCycStat = (int)this.pcCyclingStatus.value;
        if (pcCycStat != this.oldPcCycStat) {
            changed = true;
        }
        this.oldPcCycStat = pcCycStat;
        this.vacState.setCyclingStatus(pcCycStat);
        int pcVentStat = (int)this.pcVentingStatus.value;
        if (pcVentStat != this.oldPcVentStat) {
            changed = true;
        }
        this.oldPcVentStat = pcVentStat;
        this.vacState.setVentingStatus(pcVentStat);
        this.vacState.setCryoTurboPumpSwitchState(this.cryoTurboStat.value == (double)TwisTorr.PumpStatus.NORMAL.ordinal());
        this.vacState.setHXTurboPumpSwitchState(this.hxTurboStat.value == (double)TwisTorr.PumpStatus.NORMAL.ordinal());
        this.vacState.setCryoTurboVentingSwitchState(this.vacState.getSwitchState(26) == SwitchState.ON);
        this.vacState.setHXTurboVentingSwitchState(this.vacState.getSwitchState(27) == SwitchState.ON);
        this.readSensor(this.cryoFlineValveStatus);
        this.readSensor(this.hxFlineValveStatus);
        boolean limitSwitchesPowered = false;
        if (this.qbs != null) {
            limitSwitchesPowered = this.qbs.getSwitchState(522) == org.lsst.ccs.subsystem.power.constants.SwitchState.ON;
        }
        int n = cryoFlValveStat = limitSwitchesPowered ? (int)this.cryoFlineValveStatus.value : DeviceState.OFFLINE.ordinal();
        if (cryoFlValveStat != this.oldCryoFlValveStat) {
            changed = true;
        }
        this.oldCryoFlValveStat = cryoFlValveStat;
        this.vacState.setCryoForelineValveStatus(DeviceState.values()[cryoFlValveStat].name());
        int n2 = hxFlValveStat = limitSwitchesPowered ? (int)this.hxFlineValveStatus.value : DeviceState.OFFLINE.ordinal();
        if (hxFlValveStat != this.oldhxFlValveStat) {
            changed = true;
        }
        this.oldhxFlValveStat = hxFlValveStat;
        this.vacState.setHXForelineValveStatus(DeviceState.values()[hxFlValveStat].name());
        double pUpdateScale = 0.5;
        this.vacState.setCryoPress(this.cryoMainPrs.value);
        if (Math.abs(this.oldCryoMainPrs - this.cryoMainPrs.value) > Math.min(this.pChangeStateUpdate, pUpdateScale * this.oldCryoMainPrs)) {
            changed = true;
            this.oldCryoMainPrs = this.cryoMainPrs.value;
        }
        this.vacState.setCryoTurboPress(this.cryoTurboPrs.value);
        if (Math.abs(this.oldCryoTurboPrs - this.cryoTurboPrs.value) > Math.min(this.pChangeStateUpdate, pUpdateScale * this.oldCryoTurboPrs)) {
            changed = true;
            this.oldCryoTurboPrs = this.cryoTurboPrs.value;
        }
        this.vacState.setCryoFlinePress(this.cryoFlinePrs.value);
        if (Math.abs(this.oldCryoFlinePrs - this.cryoFlinePrs.value) > Math.min(this.pFLChangeStateUpdate, pUpdateScale * this.oldCryoFlinePrs)) {
            changed = true;
            this.oldCryoFlinePrs = this.cryoFlinePrs.value;
        }
        this.vacState.setHXPress(this.hxMainPrs.value);
        if (Math.abs(this.oldHxMainPrs - this.hxMainPrs.value) > Math.min(this.pChangeStateUpdate, pUpdateScale * this.oldHxMainPrs)) {
            changed = true;
            this.oldHxMainPrs = this.hxMainPrs.value;
        }
        this.vacState.setHXTurboPress(this.hxTurboPrs.value);
        if (Math.abs(this.oldHxTurboPrs - this.hxTurboPrs.value) > Math.min(this.pChangeStateUpdate, pUpdateScale * this.oldHxTurboPrs)) {
            changed = true;
            this.oldHxTurboPrs = this.hxTurboPrs.value;
        }
        this.vacState.setHXFlinePress(this.hxFlinePrs.value);
        if (Math.abs(this.oldHxFlinePrs - this.hxFlinePrs.value) > Math.min(this.pFLChangeStateUpdate, pUpdateScale * this.oldHxFlinePrs)) {
            changed = true;
            this.oldHxFlinePrs = this.hxFlinePrs.value;
        }
        this.vacState.setPCPress(this.pcInletPressure.value);
        if (Math.abs(this.oldPCPrs - this.pcInletPressure.value) > Math.min(this.pPCChangeStateUpdate, this.oldPCPrs)) {
            changed = true;
            this.oldPCPrs = this.pcInletPressure.value;
        }
        this.vacState.setPCTargetPressureSrc(this.pumpCartDevc.getTargetPressureSrc());
        try {
            this.vacState.setPCTargetPressure(this.pumpCartDevc.getReferencePressure());
        }
        catch (DriverException ex) {
            LOG.log(Level.SEVERE, "Failed to set reference pressure value in VacSysState.", ex);
        }
        this.pumpCartDevc.updateVacSysState(this.vacState);
        this.vacState.setMaxVentPressure(this.pumpCartDevc.getMaxVentPressure());
        this.vacState.setMinPumpPressure(this.pumpCartDevc.getMinPumpPressure());
        return changed;
    }

    private boolean updatePlcState() {
        boolean changed = false;
        Boolean plcActive = this.vacPlutoDevc.isPLCActive();
        if (plcActive == null) {
            if (this.vacState.getPlcState() != PLCState.OFFLINE) {
                this.raiseAlarm(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is offline", null);
                this.vacState.setPlcState(PLCState.OFFLINE);
                changed = true;
            }
        } else if (!plcActive.booleanValue()) {
            if (this.vacState.getPlcState() != PLCState.DEAD) {
                this.raiseAlarm(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC has died", null);
                this.vacState.setPlcState(PLCState.DEAD);
                changed = true;
            }
        } else if (this.vacState.getPlcState() != PLCState.ALIVE) {
            this.lowerAlarm(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is alive", null);
            this.vacState.setPlcState(PLCState.ALIVE);
            changed = true;
        }
        return changed;
    }

    private boolean updateLatchState() {
        boolean changed = false;
        for (int cond = 0; cond < 8; ++cond) {
            LatchState oldState;
            Boolean active = this.vacPlutoDevc.isLatchActive(cond);
            Boolean latched = this.vacPlutoDevc.isLatchLatched(cond);
            LatchState state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR));
            if (state == (oldState = this.vacState.getLatch(cond))) continue;
            this.vacState.setLatch(cond, state);
            VacuumAlert alert = latchAlertMap.get(cond);
            if (state == LatchState.ACTIVE) {
                this.raiseAlarm(alert, "Vacuum PLC error condition set", null);
            } else if (state != LatchState.OFFLINE && oldState != LatchState.OFFLINE) {
                if (state == LatchState.LATCHED && oldState == LatchState.CLEAR) {
                    this.raiseAlarm(alert, "Vacuum PLC error condition set", null);
                }
                if (state == LatchState.LATCHED || oldState == LatchState.ACTIVE) {
                    this.lowerAlarm(alert, "Vacuum PLC error condition cleared", null);
                }
            }
            changed = true;
        }
        return changed;
    }

    private boolean updateCondState() {
        boolean changed = false;
        for (int cond = 0; cond < 10; ++cond) {
            ConditionState state;
            Boolean active = this.vacPlutoDevc.isConditionActive(cond);
            ConditionState conditionState = active == null ? ConditionState.OFF : (state = active != false ? ConditionState.YES : ConditionState.NO);
            if (state == this.vacState.getCondition(cond)) continue;
            this.vacState.setCondition(cond, state);
            changed = true;
        }
        return changed;
    }

    private boolean readSensors() {
        boolean valid = true;
        valid &= this.readSensor(this.cryoFlinePrs);
        valid &= this.readSensor(this.cryoMainPrs);
        valid &= this.readSensor(this.cryoTurboPrs);
        valid &= this.readSensor(this.cryoTurboSpd);
        valid &= this.readSensor(this.cryoTurboTmp);
        valid &= this.readSensor(this.cryoTurboPwr);
        valid &= this.readSensor(this.cryoTurboStat);
        valid &= this.readSensor(this.hxFlinePrs);
        valid &= this.readSensor(this.hxMainPrs);
        valid &= this.readSensor(this.hxTurboPrs);
        valid &= this.readSensor(this.hxTurboSpd);
        valid &= this.readSensor(this.hxTurboTmp);
        valid &= this.readSensor(this.hxTurboPwr);
        valid &= this.readSensor(this.hxTurboStat);
        return valid &= this.readSensor(this.cmpAirPrs);
    }

    private boolean readSensor(SensorData data) {
        Measurement meas = data.channel.getLastMeasurement();
        if (meas.getCCSTimestamp() == null) {
            return false;
        }
        data.valueCCSTimestamp = meas.getCCSTimestamp();
        data.value = meas.getValue();
        if (!Double.isNaN(data.value)) {
            data.goodValue = data.value;
            data.goodValueCCSTimestamp = data.valueCCSTimestamp;
            data.numErrors = 0;
        } else if (data.numErrors++ < data.maxErrors) {
            data.value = data.goodValue;
        }
        if (data.getLimits) {
            data.lowLimit = data.channel.getLimitLo();
            data.highLimit = data.channel.getLimitHi();
        }
        return true;
    }

    private boolean updateSwitchState() {
        boolean changed = false;
        changed |= this.updateCryoGateValve();
        changed |= this.updateCryoTurboPump();
        changed |= this.updateCryoTurboPumpVentValve();
        changed |= this.updateCryoIonPumps();
        changed |= this.updateHxGateValve();
        changed |= this.updateHxTurboPump();
        changed |= this.updateHxTurboPumpVentValve();
        changed |= this.updateHxIonPumps();
        changed |= this.updateUtSwitches();
        changed |= this.updateCryoVacCC();
        changed |= this.updateCryoTurboCC();
        changed |= this.updateHxVacCC();
        return changed |= this.updateHxTurboCC();
    }

    private boolean updateCryoGateValve() {
        boolean airCompressorOK;
        boolean enable = false;
        boolean turnOff = true;
        boolean cryoTurboAvail = !Double.isNaN(this.cryoMainPrs.value) && !Double.isNaN(this.cryoTurboPrs.value) && !Double.isNaN(this.cryoTurboSpd.value);
        boolean bl = airCompressorOK = this.cmpAirPrs.value > this.cmpAirPrs.lowLimit && this.cmpAirPrs.value < this.cmpAirPrs.highLimit;
        if (airCompressorOK && this.testingModeOn) {
            turnOff = false;
            if (turnOff |= (int)this.cryoTurboStat.value == this.turboFailureCode) {
                LOG.log(Level.FINE, "Turbo failure check would have caused gate valve to close.");
            }
        }
        if (cryoTurboAvail && airCompressorOK) {
            double pressDiffLim;
            enable = true;
            double prDiff = Math.abs(this.cryoTurboPrs.value - this.cryoMainPrs.value);
            enable = this.cryoTurboSpd.value <= this.speedCryoTurboLow ? (enable &= prDiff <= (pressDiffLim = this.pressDiffHighMin + Math.sqrt(this.cryoMainPrs.value / 780.0) * (20.0 - this.pressDiffHighMin))) : (enable &= prDiff <= this.pressDiffLow);
            enable &= this.cryoMainPrs.value + this.cryoPdiffFloor > this.cryoPScale * this.cryoTurboPrs.value;
            turnOff = false;
            turnOff |= this.cryoFlinePrs.value > this.pressForelineLow && this.cryoTurboSpd.value > this.speedCryoTurboLow;
            turnOff |= this.cryoTurboTmp.value > this.cryoTurboTmp.highLimit;
            turnOff |= this.cryoTurboPwr.value > this.cryoTurboPwr.highLimit;
            turnOff |= (int)this.cryoTurboStat.value == this.turboFailureCode;
            if (this.pumpCartDevc.getPumpSwitchState() && this.pcCyclingStatus.valueCCSTimestamp != null) {
                boolean turnOffFromPC = false;
                turnOffFromPC |= (this.pcCyclingStatus.value < 1.0 || Double.isNaN(this.pcCyclingStatus.value)) && this.pcCyclingStatus.valueCCSTimestamp.getUTCDouble() > this.pumpCartDevc.getPumpSwitchStateTime().getUTCDouble();
                turnOff |= (turnOffFromPC |= this.pcCyclingStatus.numErrors > 2);
                if (turnOffFromPC) {
                    LOG.fine("Pump cart caused gate valve to close");
                    if (this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(7)) == DeviceState.OPEN) {
                        LOG.info("Pump cart causing gate valve to close with the following conditions: pumping = " + (this.pcCyclingStatus.value > 0.0) + " #errors = " + this.pcCyclingStatus.numErrors + " pcCyclingStatus.valueCCSTimestamp > pumpCartDevc.getPumpSwitchStateTime: (" + (this.pcCyclingStatus.valueCCSTimestamp.getUTCDouble() > this.pumpCartDevc.getPumpSwitchStateTime().getUTCDouble()) + ")");
                    }
                }
            }
        }
        LOG.log(Level.FINE, "Gate valve decision inputs:  airCompressorOK " + airCompressorOK + ", cryoTurboAvail " + cryoTurboAvail + ", cryoFlinePrs.value " + this.cryoFlinePrs.value + ", pressForelineLow " + this.pressForelineLow + ", cryoTurboSpd.value " + this.cryoTurboSpd.value + ", speedCryoTurboLow " + this.speedCryoTurboLow + ", cryoTurboTmp.value " + this.cryoTurboTmp.value + ", cryoTurboTmp.highLimit " + this.cryoTurboTmp.highLimit + ", cryoTurboPwr.value " + this.cryoTurboPwr.value + ", cryoTurboPwr.highLimit " + this.cryoTurboPwr.highLimit + ", 1st or condition: cryoFlinePrs.value < pressForelineLow " + (this.cryoFlinePrs.value < this.pressForelineLow) + ", 2nd or condition: cryoTurboSpd.value <= speedCryoTurboLow " + (this.cryoTurboSpd.value <= this.speedCryoTurboLow) + ", turnOff " + turnOff);
        return this.updateSwitch(7, enable &= !turnOff, turnOff, this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(7)), VacuumAlert.CRYO_GATE_CLOSED);
    }

    private boolean updateCryoTurboPumpVentValve() {
        boolean enable = true;
        boolean turnOff = false;
        enable &= this.cryoTurboStat.value != (double)TwisTorr.PumpStatus.WAIT_INTLK.ordinal() && this.cryoTurboStat.value != (double)TwisTorr.PumpStatus.STARTING.ordinal() && this.cryoTurboStat.value != (double)TwisTorr.PumpStatus.AUTO_TUNING.ordinal() && this.cryoTurboStat.value != (double)TwisTorr.PumpStatus.NORMAL.ordinal();
        enable &= this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(7)) == DeviceState.SHUT;
        boolean enable_isolated = false;
        try {
            enable_isolated = DeviceState.valueOf((String)this.vacState.getHXForelineValveStatus()) == DeviceState.SHUT;
        }
        catch (NullPointerException e) {
            LOG.log(Level.SEVERE, "Error: Failed to retrieve HX foreline valve status", e);
        }
        if (!enable_isolated) {
            try {
                enable_isolated |= this.vacState.getDeviceState(12) == DeviceState.SHUT && this.hxTurboStat.value == (double)TwisTorr.PumpStatus.STOP.ordinal();
            }
            catch (NullPointerException e) {
                LOG.log(Level.SEVERE, "Error: Failed check of isolation in turbo stopped state {0}", e);
            }
        }
        turnOff |= !(enable &= enable_isolated);
        Boolean state = this.cryoTurboDevc.getVentValveOpenState();
        DeviceState ventDevState = state == null ? DeviceState.OFFLINE : (state != false ? DeviceState.OPEN : DeviceState.SHUT);
        return this.updateSwitch(26, enable &= !(turnOff |= Double.isNaN(this.pcCyclingStatus.value)), turnOff, ventDevState, VacuumAlert.CRYO_TURBO_PUMP_VENT_CLOSED);
    }

    private boolean updateCryoTurboPump() {
        boolean enable = false;
        if (!(Double.isNaN(this.cryoTurboPrs.value) || Double.isNaN(this.cryoFlinePrs.value) || Double.isNaN(this.cryoTurboSpd.value))) {
            enable = this.cryoTurboPrs.value < this.pressTurboLow && (this.cryoFlinePrs.value < this.pressForelineLow || this.cryoTurboSpd.value < this.speedCryoTurboLow);
        }
        LOG.log(Level.FINE, "turbo pump enable decision inputs: , cryoTurboPrs.value " + this.cryoTurboPrs.value + ", cryoFlinePrs.value " + this.cryoFlinePrs.value + ", cryoTurboSpd.value " + this.cryoTurboSpd.value + ", pressForelineLow " + this.pressForelineLow + ", speedCryoTurboLow " + this.speedCryoTurboLow + ", cryoTurboPwr.highLimit " + this.cryoTurboPwr.highLimit + ", 1st or condition: cryoFlinePrs.value < pressForelineLow " + (this.cryoFlinePrs.value < this.pressForelineLow) + ", 2nd or condition: cryoTurboSpd.value <= speedCryoTurboLow " + (this.cryoTurboSpd.value <= this.speedCryoTurboLow) + ", enable " + enable);
        return this.updateSwitch(0, enable, !enable, this.cryoTurboDevc.getDeviceState(), VacuumAlert.CRYO_TURBO_PUMP_STOPPED);
    }

    private boolean updateCryoIonPumps() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.cryoMainPrs.value)) {
            boolean bl = enable = this.cryoMainPrs.value < this.pressIonEnable;
            if (this.cryoMainPrs.value >= this.pressIonOff) {
                if (this.cryoIonOverStartTime == 0L) {
                    this.cryoIonOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = System.currentTimeMillis() - this.cryoIonOverStartTime >= 10000L;
                }
            } else {
                this.cryoIonOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        for (int sw : cryoIonPumps) {
            changed |= this.updateSwitch(sw, enable, turnOff, null, VacuumAlert.CRYO_ION_PUMPS_STOPPED);
        }
        return changed;
    }

    private boolean updateHxTurboPumpVentValve() {
        boolean enable = true;
        boolean turnOff = false;
        DeviceState ventDevState = DeviceState.OFFLINE;
        int sw = 27;
        enable &= this.hxTurboStat.value != (double)TwisTorr.PumpStatus.WAIT_INTLK.ordinal() && this.hxTurboStat.value != (double)TwisTorr.PumpStatus.STARTING.ordinal() && this.hxTurboStat.value != (double)TwisTorr.PumpStatus.AUTO_TUNING.ordinal() && this.hxTurboStat.value != (double)TwisTorr.PumpStatus.NORMAL.ordinal();
        enable &= this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(12)) == DeviceState.SHUT;
        boolean enable_isolated = false;
        try {
            enable_isolated = DeviceState.valueOf((String)this.vacState.getCryoForelineValveStatus()) == DeviceState.SHUT;
        }
        catch (NullPointerException e) {
            LOG.log(Level.SEVERE, "Error: Failed to retrieve Cryo foreline valve status", e);
        }
        if (!enable_isolated) {
            try {
                enable_isolated |= this.vacState.getDeviceState(7) == DeviceState.SHUT && this.cryoTurboStat.value == (double)TwisTorr.PumpStatus.STOP.ordinal();
            }
            catch (NullPointerException e) {
                LOG.log(Level.SEVERE, "Error: Failed check of isolation in turbo stopped state {0}", e);
            }
        }
        turnOff |= !(enable &= enable_isolated);
        Boolean state = this.hxTurboDevc.getVentValveOpenState();
        ventDevState = state == null ? DeviceState.OFFLINE : (state != false ? DeviceState.OPEN : DeviceState.SHUT);
        return this.updateSwitch(27, enable &= !(turnOff |= Double.isNaN(this.pcCyclingStatus.value)), turnOff, ventDevState, VacuumAlert.HX_TURBO_PUMP_VENT_CLOSED);
    }

    private boolean updateHxGateValve() {
        boolean airCompressorOK;
        boolean enable = false;
        boolean turnOff = true;
        boolean hxTurboAvail = !Double.isNaN(this.hxMainPrs.value) && !Double.isNaN(this.hxTurboPrs.value) && !Double.isNaN(this.hxTurboSpd.value);
        boolean bl = airCompressorOK = this.cmpAirPrs.value > this.cmpAirPrs.lowLimit && this.cmpAirPrs.value < this.cmpAirPrs.highLimit;
        if (airCompressorOK && this.testingModeOn) {
            turnOff = false;
            turnOff |= this.hxTurboTmp.value > this.hxTurboTmp.highLimit || this.hxTurboPwr.value > this.hxTurboPwr.highLimit;
            LOG.log(Level.FINE, "hxTurboStat = " + (int)this.hxTurboStat.value);
            turnOff |= this.hxTurboTmp.value > this.hxTurboTmp.highLimit;
            turnOff |= this.hxTurboPwr.value > this.hxTurboPwr.highLimit;
            if (turnOff |= (int)this.hxTurboStat.value == this.turboFailureCode) {
                LOG.log(Level.FINE, "Turbo failure check would have caused gate valve to close.");
            }
        }
        if (hxTurboAvail && airCompressorOK) {
            double pressDiffLim;
            enable = true;
            double prDiff = Math.abs(this.hxTurboPrs.value - this.hxMainPrs.value);
            enable = this.hxTurboSpd.value <= this.speedHxTurboLow ? (enable &= prDiff <= (pressDiffLim = this.pressDiffHighMin + Math.sqrt(this.hxMainPrs.value / 780.0) * (20.0 - this.pressDiffHighMin))) : (enable &= prDiff <= this.pressDiffLow);
            enable &= this.hxMainPrs.value + this.hxPdiffFloor > this.hxPScale * this.hxTurboPrs.value;
            turnOff = false;
            turnOff |= this.hxFlinePrs.value > this.pressForelineLow && this.hxTurboSpd.value > this.speedHxTurboLow;
            turnOff |= this.hxTurboTmp.value > this.hxTurboTmp.highLimit;
            turnOff |= this.hxTurboPwr.value > this.hxTurboPwr.highLimit;
            turnOff |= (int)this.hxTurboStat.value == this.turboFailureCode;
            if (this.pumpCartDevc.getPumpSwitchState() && this.pcCyclingStatus.valueCCSTimestamp != null) {
                boolean turnOffFromPC = false;
                turnOffFromPC |= (this.pcCyclingStatus.value < 1.0 || Double.isNaN(this.pcCyclingStatus.value)) && this.pcCyclingStatus.valueCCSTimestamp.getUTCDouble() > this.pumpCartDevc.getPumpSwitchStateTime().getUTCDouble();
                turnOff |= (turnOffFromPC |= this.pcCyclingStatus.numErrors > 2);
                if (turnOffFromPC) {
                    LOG.fine("Pump cart caused gate valve to close");
                    if (this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(12)) == DeviceState.OPEN) {
                        LOG.info("Pump cart causing gate valve to close with the following conditions: pumping = " + (this.pcCyclingStatus.value > 0.0) + " #errors = " + this.pcCyclingStatus.numErrors + " pcCyclingStatus.valueCCSTimestamp > pumpCartDevc.getPumpSwitchStateTime: (" + (this.pcCyclingStatus.valueCCSTimestamp.getUTCDouble() > this.pumpCartDevc.getPumpSwitchStateTime().getUTCDouble()) + ")");
                    }
                }
            }
        }
        LOG.log(Level.FINE, "Gate valve decision inputs:  airCompressorOK " + airCompressorOK + ", hxTurboAvail " + hxTurboAvail + ", hxFlinePrs.value " + this.hxFlinePrs.value + ", pressForelineLow " + this.pressForelineLow + ", hxTurboSpd.value " + this.hxTurboSpd.value + ", speedHxTurboLow " + this.speedHxTurboLow + ", hxTurboTmp.value " + this.hxTurboTmp.value + ", hxTurboTmp.highLimit " + this.hxTurboTmp.highLimit + ", hxTurboPwr.value " + this.hxTurboPwr.value + ", hxTurboPwr.highLimit " + this.hxTurboPwr.highLimit + ", 1st or condition: hxFlinePrs.value < pressForelineLow " + (this.hxFlinePrs.value < this.pressForelineLow) + ", 2nd or condition: hxTurboSpd.value <= speedHxTurboLow " + (this.hxTurboSpd.value <= this.speedHxTurboLow) + ", turnOff " + turnOff);
        return this.updateSwitch(12, enable &= !turnOff, turnOff, this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(12)), VacuumAlert.HX_GATE_CLOSED);
    }

    private boolean updateHxTurboPump() {
        boolean enable = false;
        int sw = 9;
        if (!(Double.isNaN(this.hxTurboPrs.value) || Double.isNaN(this.hxFlinePrs.value) || Double.isNaN(this.hxTurboSpd.value))) {
            enable = this.hxTurboPrs.value < this.pressTurboLow && (this.hxFlinePrs.value < this.pressForelineLow || this.hxTurboSpd.value < this.speedHxTurboLow);
        }
        LOG.log(Level.FINE, "turbo pump enable decision inputs: , hxTurboPrs.value " + this.hxTurboPrs.value + ", hxFlinePrs.value " + this.hxFlinePrs.value + ", hxTurboSpd.value " + this.hxTurboSpd.value + ", pressForelineLow " + this.pressForelineLow + ", speedHxTurboLow " + this.speedHxTurboLow + ", hxTurboPwr.highLimit " + this.hxTurboPwr.highLimit + ", 1st or condition: hxFlinePrs.value < pressForelineLow " + (this.hxFlinePrs.value < this.pressForelineLow) + ", 2nd or condition: hxTurboSpd.value <= speedHxTurboLow " + (this.hxTurboSpd.value <= this.speedHxTurboLow) + ", enable " + enable);
        return this.updateSwitch(sw, enable, !enable, this.hxTurboDevc.getDeviceState(), VacuumAlert.HX_TURBO_PUMP_STOPPED);
    }

    private boolean updateHxIonPumps() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.hxMainPrs.value)) {
            boolean bl = enable = this.hxMainPrs.value < this.pressIonEnable;
            if (this.hxMainPrs.value >= this.pressIonOff) {
                if (this.hxIonOverStartTime == 0L) {
                    this.hxIonOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = System.currentTimeMillis() - this.hxIonOverStartTime >= 10000L;
                }
            } else {
                this.hxIonOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        for (int sw : hxIonPumps) {
            changed |= this.updateSwitch(sw, enable, turnOff, null, VacuumAlert.HX_ION_PUMPS_STOPPED);
        }
        return changed;
    }

    private boolean updateCryoVacCC() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.cryoMainPrs.value)) {
            boolean bl = enable = this.cryoMainPrs.value <= this.pressCCEnable;
            if (this.cryoMainPrs.value >= this.pressCCOff) {
                if (this.cryoVacCCOverStartTime == 0L) {
                    this.cryoVacCCOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = (double)(System.currentTimeMillis() - this.cryoVacCCOverStartTime) >= this.delayCCOff;
                }
            } else {
                this.cryoVacCCOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        return changed |= this.updateSwitch(19, enable, turnOff, null, VacuumAlert.CRYO_VAC_CC_STOPPED);
    }

    private boolean updateCryoTurboCC() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.cryoTurboPrs.value)) {
            boolean bl = enable = this.cryoTurboPrs.value < this.pressCCEnable;
            if (this.cryoTurboPrs.value >= this.pressCCOff) {
                if (this.cryoTurboCCOverStartTime == 0L) {
                    this.cryoTurboCCOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = (double)(System.currentTimeMillis() - this.cryoTurboCCOverStartTime) >= this.delayCCOff;
                }
            } else {
                this.cryoTurboCCOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        return changed |= this.updateSwitch(20, enable, turnOff, null, VacuumAlert.CRYO_TURBO_CC_STOPPED);
    }

    private boolean updateHxVacCC() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.hxMainPrs.value)) {
            boolean bl = enable = this.hxMainPrs.value < this.pressCCEnable;
            if (this.hxMainPrs.value >= this.pressCCOff) {
                if (this.hxVacCCOverStartTime == 0L) {
                    this.hxVacCCOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = (double)(System.currentTimeMillis() - this.hxVacCCOverStartTime) >= this.delayCCOff;
                }
            } else {
                this.hxVacCCOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        return changed |= this.updateSwitch(21, enable, turnOff, null, VacuumAlert.HX_VAC_CC_STOPPED);
    }

    private boolean updateHxTurboCC() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.hxTurboPrs.value)) {
            boolean bl = enable = this.hxTurboPrs.value < this.pressCCEnable;
            if (this.hxTurboPrs.value >= this.pressCCOff) {
                if (this.hxTurboCCOverStartTime == 0L) {
                    this.hxTurboCCOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = (double)(System.currentTimeMillis() - this.hxTurboCCOverStartTime) >= this.delayCCOff;
                }
            } else {
                this.hxTurboCCOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        return changed |= this.updateSwitch(22, enable, turnOff, null, VacuumAlert.HX_TURBO_CC_STOPPED);
    }

    private boolean updateUtSwitches() {
        boolean changed = false;
        this.speedCryoTurboLow = this.speedFractTurboLow * 60000.0;
        this.speedHxTurboLow = this.speedFractTurboLow * 81000.0;
        for (int sw : utSwitches) {
            boolean enable = true;
            boolean turnOff = false;
            DeviceState devState = null;
            VacuumAlert al = null;
            if (sw == 24) {
                devState = DeviceState.OFFLINE;
                try {
                    devState = DeviceState.valueOf((String)this.vacState.getCryoForelineValveStatus());
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error getting cryo foreline valve state: ", e);
                }
                if (this.pcInletPressure.value < 750.0) {
                    enable = Math.abs(this.pcInletPressure.value - this.cryoFlinePrs.value) < this.maxInletFlinePressDiff();
                } else {
                    boolean bl = enable = this.cryoFlinePrs.value > 750.0 - this.maxInletFlinePressDiff();
                }
                if ((int)this.cryoTurboStat.value == this.turboFailureCode) {
                    al = VacuumAlert.CRYO_FLINE_FORCED_CLOSED_BY_TURBO;
                    turnOff = true;
                }
                if (this.isAlarmRaised(VacuumAlert.CRYO_GATE_POSN_ERROR)) {
                    al = VacuumAlert.CRYO_FLINE_FORCED_CLOSED_BY_GV;
                    turnOff = true;
                }
                if (this.cryoFlinePrs.value > this.pressForelineLow && (this.cryoTurboSpd.value > this.speedCryoTurboLow || this.testingModeOn)) {
                    al = VacuumAlert.CRYO_FLINE_FORCED_CLOSED_BY_FLPRS;
                    turnOff = true;
                }
            } else if (sw == 25) {
                devState = DeviceState.OFFLINE;
                try {
                    devState = DeviceState.valueOf((String)this.vacState.getHXForelineValveStatus());
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error getting HX foreline valve state: ", e);
                }
                if (this.pcInletPressure.value < 750.0) {
                    enable = Math.abs(this.pcInletPressure.value - this.hxFlinePrs.value) < this.maxInletFlinePressDiff();
                } else {
                    boolean bl = enable = this.cryoFlinePrs.value > 750.0 - this.maxInletFlinePressDiff();
                }
                if ((int)this.hxTurboStat.value == this.turboFailureCode) {
                    al = VacuumAlert.HX_FLINE_FORCED_CLOSED_BY_TURBO;
                    turnOff = true;
                }
                if (this.isAlarmRaised(VacuumAlert.HX_GATE_POSN_ERROR)) {
                    al = VacuumAlert.HX_FLINE_FORCED_CLOSED_BY_GV;
                    turnOff = true;
                }
                if (this.hxFlinePrs.value > this.pressForelineLow && (this.hxTurboSpd.value > this.speedHxTurboLow || this.testingModeOn)) {
                    al = VacuumAlert.HX_FLINE_FORCED_CLOSED_BY_FLPRS;
                    turnOff = true;
                }
            }
            changed |= this.updateSwitch(sw, enable, turnOff, devState, al);
        }
        return changed;
    }

    @Command(type=Command.CommandType.QUERY, description="determines what is the allowable pressure difference btwn the foreline and the PC inlet pressure")
    public double maxInletFlinePressDiff() {
        return this.pcPdiffFloor + this.pcPdiffScaleFactor * this.pcInletPressure.value;
    }

    private boolean updateSwitch(int sw, boolean enable, boolean turnOff, DeviceState devState, VacuumAlert alert) {
        Long transitTime;
        DeviceState oldDevState;
        SwitchEnable enabled;
        Boolean isOn;
        boolean changed = false;
        SwitchState oldState = this.vacState.getSwitchState(sw);
        if (turnOff && oldState == SwitchState.ON) {
            try {
                this.setSwitch(sw, false);
                this.raiseAlarm(alert, "Switch was forced to open", null);
            }
            catch (VacuumException e) {
                LOG.log(Level.SEVERE, "Error setting switch: {0}", e);
            }
        }
        SwitchState state = (isOn = this.isSwitchOn(sw)) != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : SwitchState.OFFLINE;
        SwitchEnable switchEnable = enabled = enable ? SwitchEnable.ON : SwitchEnable.OFF;
        if (state != oldState || enabled != this.vacState.getSwitchEnable(sw)) {
            this.vacState.setSwitchState(sw, state);
            this.vacState.setSwitchEnable(sw, enabled);
            changed = true;
            if (enable && alert != null && this.isAlarmRaised(alert)) {
                this.lowerAlarm(alert, "Switch has become re-enabled", null);
            }
        }
        if (devState != (oldDevState = this.vacState.getDeviceState(sw))) {
            if (sw == 7 || sw == 12) {
                if (oldDevState == DeviceState.ERROR) {
                    this.lowerAlarm(sw == 7 ? VacuumAlert.CRYO_GATE_POSN_ERROR : VacuumAlert.HX_GATE_POSN_ERROR, "Gate valve no longer reading both open and closed", null);
                } else if (oldDevState == DeviceState.TRANSIT && this.gateTransitStart.get(sw) == null) {
                    this.lowerAlarm(sw == 7 ? VacuumAlert.CRYO_GATE_IN_TRANSIT : VacuumAlert.HX_GATE_IN_TRANSIT, "Gate valve no longer in too-long transition", null);
                }
                if (devState == DeviceState.ERROR) {
                    this.raiseAlarm(sw == 7 ? VacuumAlert.CRYO_GATE_POSN_ERROR : VacuumAlert.HX_GATE_POSN_ERROR, "Gate valve reading both open and closed", null);
                } else if (devState == DeviceState.TRANSIT) {
                    this.gateTransitStart.put(sw, System.currentTimeMillis());
                }
            }
            this.vacState.setDeviceState(sw, devState);
            changed = true;
        }
        if (devState == DeviceState.TRANSIT && (sw == 7 || sw == 12) && (transitTime = this.gateTransitStart.get(sw)) != null && System.currentTimeMillis() - transitTime > (sw == 7 ? this.tranTimeCryoGate : this.tranTimeHxGate)) {
            this.raiseAlarm(sw == 7 ? VacuumAlert.CRYO_GATE_IN_TRANSIT : VacuumAlert.HX_GATE_IN_TRANSIT, "Gate valve in transition for too long", null);
            this.gateTransitStart.remove(sw);
        }
        return changed;
    }

    private void checkRefrigVacuum() {
        boolean haveAlarm = this.isAlarmRaised(VacuumAlert.REFRIG_NOT_PERMITTED);
        if (this.cryoMainPrs.value < this.pressRefrigOk && this.hxMainPrs.value < this.pressRefrigOk) {
            if (haveAlarm) {
                this.lowerAlarm(VacuumAlert.REFRIG_NOT_PERMITTED, "Cryo & HX vacuums are good (< " + this.pressRefrigOk + ")", RefrigAction.Action.VACUUM_INSUFFICIENT);
            }
            this.vacBadTime = 0L;
        } else {
            long time = System.currentTimeMillis();
            if (this.vacBadTime == 0L) {
                this.vacBadTime = time;
            } else if (time - this.vacBadTime >= 10000L && !haveAlarm) {
                this.raiseAlarm(VacuumAlert.REFRIG_NOT_PERMITTED, "Cryo or HX vacuum is bad (>= " + this.pressRefrigOk + ")", RefrigAction.Action.VACUUM_INSUFFICIENT);
            }
        }
    }

    private boolean updateCryoState() {
        boolean changed = false;
        CryoVacuumState cvState = Double.isNaN(this.cryoMainPrs.value) ? CryoVacuumState.UNKNOWN : (this.cryoMainPrs.value <= this.pressVacuum ? CryoVacuumState.VACUUM : (this.vacState.getSwitchState(1) == SwitchState.ON ? CryoVacuumState.ION_ON : (this.vacState.getSwitchEnable(1) == SwitchEnable.ON ? CryoVacuumState.ION_OFF : (this.vacState.getSwitchState(0) == SwitchState.ON ? CryoVacuumState.TURBO_ON : (this.vacState.getSwitchEnable(0) == SwitchEnable.ON ? CryoVacuumState.TURBO_OFF : (this.cryoMainPrs.value < 759.0 ? CryoVacuumState.FORELINE : CryoVacuumState.OFF))))));
        if (cvState != this.vacState.getCryoVacuumState()) {
            this.vacState.setCryoVacuumState(cvState);
            this.stateService.updateAgentState(new Enum[]{cvState});
            changed = true;
        }
        return changed;
    }

    private boolean updateHxState() {
        boolean changed = false;
        HxVacuumState hvState = Double.isNaN(this.hxMainPrs.value) ? HxVacuumState.UNKNOWN : (this.hxMainPrs.value <= this.pressVacuum ? HxVacuumState.VACUUM : (this.vacState.getSwitchState(10) == SwitchState.ON ? HxVacuumState.ION_ON : (this.vacState.getSwitchEnable(10) == SwitchEnable.ON ? HxVacuumState.ION_OFF : (this.vacState.getSwitchState(9) == SwitchState.ON ? HxVacuumState.TURBO_ON : (this.vacState.getSwitchEnable(9) == SwitchEnable.ON ? HxVacuumState.TURBO_OFF : (this.hxMainPrs.value < 759.0 ? HxVacuumState.FORELINE : HxVacuumState.OFF))))));
        if (hvState != this.vacState.getHxVacuumState()) {
            this.vacState.setHxVacuumState(hvState);
            this.stateService.updateAgentState(new Enum[]{hvState});
            changed = true;
        }
        return changed;
    }

    private void raiseAlarm(VacuumAlert alert, String cond, RefrigAction.Action action) {
        try {
            Alert al = alert.getAlert();
            if (action != null) {
                RefrigAction.addData((Alert)al, (RefrigAction.Action)action);
            }
            this.alertService.raiseAlert(al, AlertState.ALARM, cond);
            this.activeAlarmMap.put(alert.getId(), true);
        }
        catch (NullPointerException e) {
            LOG.log(Level.SEVERE, "Error: Raise alert failure {0}", e);
        }
    }

    private void lowerAlarm(VacuumAlert alert, String cond, RefrigAction.Action action) {
        Alert al = alert.getAlert();
        if (action != null) {
            RefrigAction.addData((Alert)al, (RefrigAction.Action)action);
        }
        this.alertService.raiseAlert(al, AlertState.NOMINAL, cond);
        this.activeAlarmMap.put(alert.getId(), false);
    }

    private boolean isAlarmRaised(VacuumAlert alert) {
        return this.activeAlarmMap.get(alert.getId()) == Boolean.TRUE;
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() == AlertEvent.AlertEventType.ALERT_RAISED) {
            Alert raisedAlert = event.getAlert();
            String alertId = raisedAlert.getAlertId();
            if (alertId.equals(VacuumAlert.CRYO_TURBO_PUMP_POWER_HIGH.getAlert().getAlertId()) && event.getLevel() == AlertState.ALARM) {
                this.updateSwitch(0, false, true, this.cryoTurboDevc.getDeviceState(), VacuumAlert.CRYO_TURBO_PUMP_STOPPED);
                LOG.info("Stopping the cryo turbo pump due to high turbo power alert from monitoring!");
            }
            if (alertId.equals(VacuumAlert.HX_TURBO_PUMP_POWER_HIGH.getAlert().getAlertId()) && event.getLevel() == AlertState.ALARM) {
                this.updateSwitch(9, false, true, this.hxTurboDevc.getDeviceState(), VacuumAlert.HX_TURBO_PUMP_STOPPED);
                LOG.info("Stopping the hx turbo pump due to high turbo power alert from monitoring!");
            }
            if (alertId.equals(VacuumAlert.CRYO_TURBO_PUMP_TEMP_HIGH.getAlert().getAlertId()) && event.getLevel() == AlertState.ALARM) {
                this.updateSwitch(0, false, true, this.cryoTurboDevc.getDeviceState(), VacuumAlert.CRYO_TURBO_PUMP_STOPPED);
                LOG.info("Stopping the cryo turbo pump due to high turbo temp alert from monitoring!");
            }
            if (alertId.equals(VacuumAlert.HX_TURBO_PUMP_TEMP_HIGH.getAlert().getAlertId()) && event.getLevel() == AlertState.ALARM) {
                this.updateSwitch(9, false, true, this.hxTurboDevc.getDeviceState(), VacuumAlert.HX_TURBO_PUMP_STOPPED);
                LOG.info("Stopping the hx turbo pump due to high turbo temp alert from monitoring!");
            }
            if (alertId.equals(VacuumAlert.CRYO_TURBO_PUMP_FAIL.getAlert().getAlertId()) && event.getLevel() == AlertState.ALARM) {
                this.updateSwitch(SwitchInfo.getSwitch(7), false, true, this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(7)), null);
                this.updateSwitch(SwitchInfo.getSwitch(24), false, true, DeviceState.valueOf((String)this.vacState.getCryoForelineValveStatus()), null);
                LOG.info("Shutting the cryo vacuum valve due to bad turbo alert from monitoring!");
            }
            if (alertId.equals(VacuumAlert.HX_TURBO_PUMP_FAIL.getAlert().getAlertId()) && event.getLevel() == AlertState.ALARM) {
                this.updateSwitch(SwitchInfo.getSwitch(12), false, true, this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(12)), null);
                this.updateSwitch(SwitchInfo.getSwitch(25), false, true, DeviceState.valueOf((String)this.vacState.getHXForelineValveStatus()), null);
                LOG.info("Shutting the hex vacuum valves due to bad turbo alert from monitoring!");
            }
        }
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            Integer cond = revLatchAlertMap.get(id);
            if (cond == null) continue;
            try {
                this.clearLatch(cond);
            }
            catch (VacuumException e) {
                LOG.log(Level.SEVERE, "Error clearing latched PLC condition ({0}): {1}", new Object[]{cond, e});
            }
        }
    }

    private void publishState() {
        this.publishSubsystemDataOnStatusBus(new KeyValueData("VacuumState", (Serializable)this.getVacuumState()));
    }

    @Command(type=Command.CommandType.ACTION, description="test cryo gate valve position")
    public void test_cryo_gate_posn_error() throws VacuumException {
        this.raiseAlarm(VacuumAlert.CRYO_GATE_POSN_ERROR, "TESTing cryo gate posn error", null);
    }

    @Command(type=Command.CommandType.ACTION, description="test hex gate valve position")
    public void test_hex_gate_posn_error() throws VacuumException {
        this.raiseAlarm(VacuumAlert.HX_GATE_POSN_ERROR, "TESTing hex gate posn error", null);
    }

    @Command(type=Command.CommandType.ACTION, description="test turbo failure arg=turbo code")
    public void test_turbo_failure(int code) {
        this.turboFailureCode = code;
    }

    @Command(type=Command.CommandType.ACTION, description="set the vacuum subsystem testing mode on flag")
    public void set_testing_mode_on(boolean on) {
        this.testingModeOn = on;
    }

    static {
        latchAlertMap.put(0, VacuumAlert.CRYO_VACUUM_BAD);
        latchAlertMap.put(1, VacuumAlert.CRYO_GATE_FORCED_SHUT);
        latchAlertMap.put(2, VacuumAlert.CRYO_GATE_CANNOT_OPEN);
        latchAlertMap.put(3, VacuumAlert.CRYO_TURBO_PUMP_BAD);
        latchAlertMap.put(4, VacuumAlert.HX_VACUUM_BAD);
        latchAlertMap.put(5, VacuumAlert.HX_GATE_FORCED_SHUT);
        latchAlertMap.put(6, VacuumAlert.HX_GATE_CANNOT_OPEN);
        latchAlertMap.put(7, VacuumAlert.HX_TURBO_PUMP_BAD);
        revLatchAlertMap = new HashMap<String, Integer>();
        for (int cond : latchAlertMap.keySet()) {
            revLatchAlertMap.put(latchAlertMap.get(cond).getId(), cond);
        }
        cryoIonPumps = new ArrayList<Integer>();
        cryoIonPumps.add(1);
        cryoIonPumps.add(2);
        cryoIonPumps.add(3);
        cryoIonPumps.add(4);
        cryoIonPumps.add(5);
        cryoIonPumps.add(6);
        hxIonPumps = new ArrayList<Integer>();
        hxIonPumps.add(10);
        hxIonPumps.add(11);
        utSwitches = new ArrayList<Integer>();
        utSwitches.add(15);
        utSwitches.add(14);
        utSwitches.add(16);
        utSwitches.add(17);
        utSwitches.add(18);
        utSwitches.add(8);
        utSwitches.add(13);
        utSwitches.add(23);
        utSwitches.add(24);
        utSwitches.add(25);
        LOG = Logger.getLogger(VacuumMain.class.getName());
    }

    static class SensorData {
        Channel channel;
        int maxErrors;
        int numErrors = 0;
        boolean getLimits = false;
        double value = 0.0;
        CCSTimeStamp valueCCSTimestamp;
        double goodValue = Double.NaN;
        CCSTimeStamp goodValueCCSTimestamp;
        double lowLimit;
        double highLimit;

        private SensorData(Channel channel, int maxErrors, boolean getLimits) {
            this.channel = channel;
            this.maxErrors = maxErrors;
            this.getLimits = getLimits;
        }

        private SensorData(Channel channel, int maxErrors) {
            this(channel, maxErrors, false);
        }
    }

    class MyCommandOriginator
    implements CommandOriginator {
        MyCommandOriginator() {
        }

        public void processAck(CommandAck ack) {
            System.out.println("Ack!!!");
        }

        public void processNack(CommandNack nack) {
            System.out.println("Nack!!!");
        }

        public void processResult(CommandResult result) {
            System.out.println("Got result!!!" + result);
        }
    }
}

