package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;

import org.lsst.ccs.drivers.commons.DriverException;

import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.DerivedChannel;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;
import org.lsst.ccs.subsystem.vacuum.constants.Devices;

/**
 *  Handles the vacuum system MAQ20 device with monitoring of limit switches for foreline valve.
 *
 *  @author CCS
 */
public class FlineValvePositions extends DerivedChannel implements HasLifecycle {

    /**
     *  Constants.
     */
    

    protected Object ValveLimitSwitchesObj;
    protected Object RunMode;
    protected String type;

    @LookupPath
    private String path;
 

    /**
     *  Initialization.
     */
    @Override
    public void init()
    {
        if (ValveLimitSwitchesObj == null) {
            throw new RuntimeException(path + ": VacMaq20Device has not been defined");
        }
    }

    /**
     * return the state of the cryo or hx foreline valve
     * type = cryo or hx
     **/
    public String getForelineValveState(String type)
    {
        String val = null;
        if (((String)RunMode).contains("sim")) {
            if (type.contains("cryo")) {
                val = ((VacSimMaq20Device)ValveLimitSwitchesObj).getCryoLimitSwitchStateString();
            } else if (type.contains("hx")) {
                val = ((VacSimMaq20Device)ValveLimitSwitchesObj).getHxLimitSwitchStateString();
            }
        } else {
            if (type.contains("cryo")) {
                val = ((VacMaq20Device)ValveLimitSwitchesObj).getCryoLimitSwitchStateString();
            } else if (type.contains("hx")) {
                val = ((VacMaq20Device)ValveLimitSwitchesObj).getHxLimitSwitchStateString();
            }
        }
        return(val);

    }


    @Override
    public double evaluateDerivedValue()
    {

        double val = -1.0;
        if (((String)RunMode).contains("sim")) {
            if (type.contains("cryo")) {
                val = ((VacSimMaq20Device)ValveLimitSwitchesObj).getCryoLimitSwitchStateID();
            } else if (type.contains("hx")) {
                val = ((VacSimMaq20Device)ValveLimitSwitchesObj).getHxLimitSwitchStateID();
            }
        } else {
            if (type.contains("cryo")) {
                val = ((VacMaq20Device)ValveLimitSwitchesObj).getCryoLimitSwitchStateID();
            } else if (type.contains("hx")) {
                val = ((VacMaq20Device)ValveLimitSwitchesObj).getHxLimitSwitchStateID();
            }
        }
        return(val);
    }

}
