package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.subsystem.vacuum.constants.Switches;

/**
 *  Contains switch information
 * 
 *  @author saxton
 */
public class SwitchInfo {

    private static final int[] localSwitches = new int[Switches.NUM_SWITCHES];
    static {
        localSwitches[Switches.SW_CRYO_TURBO_PUMP] = VacTurboDevice.SW_PUMP;
        localSwitches[Switches.SW_CRYO_ION_PUMP1] = IonPumpDevice.CHAN_CIP1;
        localSwitches[Switches.SW_CRYO_ION_PUMP2] = IonPumpDevice.CHAN_CIP2;
        localSwitches[Switches.SW_CRYO_ION_PUMP3] = IonPumpDevice.CHAN_CIP3;
        localSwitches[Switches.SW_CRYO_ION_PUMP4] = IonPumpDevice.CHAN_CIP4;
        localSwitches[Switches.SW_CRYO_ION_PUMP5] = IonPumpDevice.CHAN_CIP5;
        localSwitches[Switches.SW_CRYO_ION_PUMP6] = IonPumpDevice.CHAN_CIP6;
        localSwitches[Switches.SW_CRYO_GATE_VALVE] = VacPlutoDevice.SW_OPEN_VCR00;
        localSwitches[Switches.SW_CRYO_SCROLL_PUMP] = VacPduDevice.CHAN_CRYO_SCROLL;
        localSwitches[Switches.SW_CRYO_FLINE_VALVE] = VacMaq20Device.SW_CRYO_FLINE_VALVE;
        localSwitches[Switches.SW_HX_TURBO_PUMP] =  VacTurboDevice.SW_PUMP;
        localSwitches[Switches.SW_HX_ION_PUMP1] = IonPumpDevice.CHAN_HIP1;
        localSwitches[Switches.SW_HX_ION_PUMP2] = IonPumpDevice.CHAN_HIP2;
        localSwitches[Switches.SW_HX_GATE_VALVE] = VacPlutoDevice.SW_OPEN_VHX00;
        localSwitches[Switches.SW_HX_SCROLL_PUMP] = VacPduDevice.CHAN_HEX_SCROLL;
        localSwitches[Switches.SW_HX_FLINE_VALVE] = VacMaq20Device.SW_HX_FLINE_VALVE;
        localSwitches[Switches.SW_INST_FTPP_VALVE] = VacMaq20Device.SW_INST_FTPP_VALVE;
        localSwitches[Switches.SW_INST_FTH_VALVE] = VacMaq20Device.SW_INST_FTH_VALVE;
        localSwitches[Switches.SW_INST_L3H_VALVE] = VacMaq20Device.SW_INST_L3H_VALVE;
        localSwitches[Switches.SW_INST_L3LF_VALVE] = VacMaq20Device.SW_INST_L3LF_VALVE;
        localSwitches[Switches.SW_INST_SCROLL_PUMP] = VacPduDevice.CHAN_INST_SCROLL;
        localSwitches[Switches.SW_INST_FLINE_VALVE] = VacMaq20Device.SW_INST_FLINE_VALVE;
        localSwitches[Switches.SW_CRYO_VAC_CC] = 0;  // only one switch per device
        localSwitches[Switches.SW_CRYO_TURBO_CC] = 0;
        localSwitches[Switches.SW_HX_VAC_CC] = 0;
        localSwitches[Switches.SW_HX_TURBO_CC] = 0;
        localSwitches[Switches.SW_CRYO_TURBO_VENT_VALVE] = VacTurboDevice.SW_VENT;
        localSwitches[Switches.SW_HX_TURBO_VENT_VALVE] = VacTurboDevice.SW_VENT;
    }

    public static int getSwitch(int sw) {
        return localSwitches[sw];
    }

}
