/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.influxdb.dto.Point;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.localdb.statusdb.LocalDBAlert;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.InfluxDbClientService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class BatchPersister<T>
implements Runnable,
ClearAlertHandler {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb");
    @LookupName
    private String persisterName;
    private static final int CONSECUTIVE_MAX_CAPACITY_LIMIT = 15;
    private final int nMax;
    private final boolean flushAtCommit;
    private final Queue<T> rq = new ConcurrentLinkedQueue<T>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent a;
    @LookupField(strategy=LookupField.Strategy.TREE)
    StatusDataPersister statusDataPersister;
    @LookupField(strategy=LookupField.Strategy.TREE)
    InfluxDbClientService influxDbClientService;
    private int nThreads = 1;
    ExecutorService exec;

    public static ExecutorService newFixedThreadPoolBoundedQueue(int nThreads, int nQueue) {
        LinkedBlockingQueue<Runnable> queue = nQueue > 0 ? new LinkedBlockingQueue<Runnable>(nQueue) : new LinkedBlockingQueue();
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, queue);
    }

    public BatchPersister(int nMax, boolean flushAtCommit, int threads, int threadQueueSize) {
        this.nMax = nMax;
        this.flushAtCommit = flushAtCommit;
        this.nThreads = threads;
        this.exec = BatchPersister.newFixedThreadPoolBoundedQueue(this.nThreads, threadQueueSize);
    }

    public BatchPersister(int nMax, boolean flushAtCommit, int threads) {
        this(nMax, flushAtCommit, threads, 10 * threads);
    }

    public BatchPersister(int nMax, boolean flushAtCommit) {
        this(nMax, flushAtCommit, 1);
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistBatch(List<T> batch) {
        log.debug((Object)("start batch " + this.getClass().getName() + " " + this + " " + batch.size()));
        long tstart = System.currentTimeMillis();
        Session sess = StatusdbUtils.getSessionFactory().openSession();
        if (this.flushAtCommit) {
            sess.setFlushMode(FlushMode.COMMIT);
        }
        Transaction tx = null;
        try {
            tx = sess.beginTransaction();
            for (T t : batch) {
                this.persist(t, sess);
            }
            tx.commit();
        }
        catch (Exception ex) {
            log.error((Object)"caught exception when persisting", (Throwable)ex);
            this.alertService.raiseAlert(LocalDBAlert.BatchException.getAlert(this.persisterName, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
            try {
                if (tx != null && (tx.getStatus() == TransactionStatus.ACTIVE || tx.getStatus() == TransactionStatus.MARKED_ROLLBACK)) {
                    tx.rollback();
                }
            }
            catch (Exception rbEx) {
                log.error((Object)("Rollback of transaction failed : " + rbEx), (Throwable)rbEx);
                this.alertService.raiseAlert(LocalDBAlert.BatchRollbackException.getAlert(this.persisterName, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
            }
        }
        finally {
            if (sess.isOpen()) {
                sess.close();
            }
        }
        long time = System.currentTimeMillis() - tstart;
        if (this.influxDbClientService != null) {
            Point.Builder batchPersisterPointBuilder = Point.measurement((String)"db_persist").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            batchPersisterPointBuilder = batchPersisterPointBuilder.addField("btime_tot", time).addField("bcount", (long)batch.size()).addField("btime_avg", (double)time / (double)batch.size());
            Point point = batchPersisterPointBuilder.tag("persister", this.persisterName).tag(this.influxDbClientService.getGlobalTags()).build();
            this.influxDbClientService.getInfluxDbClient().write(point);
        } else {
            KeyValueDataList kvdl = new KeyValueDataList(this.persisterName);
            kvdl.addData(this.persisterName + "/transactionTime", (Serializable)Long.valueOf(time));
            kvdl.addData(this.persisterName + "/batchSize", (Serializable)Integer.valueOf(batch.size()));
            kvdl.addData(this.persisterName + "/entityAverageTime", (Serializable)Double.valueOf((double)time / (double)batch.size()));
            this.statusDataPersister.processEncodedData(this.a.getName(), kvdl);
        }
        log.debug((Object)"end batch ");
    }

    @Override
    public void run() {
        log.fine((Object)("start run " + this.rq.size()));
        int n = 0;
        int nAcc = 0;
        boolean done = false;
        long tstart = System.currentTimeMillis();
        int queueAtStart = this.rq.size();
        int tasksAtStart = ((ThreadPoolExecutor)this.exec).getQueue().size();
        int nbatch = 0;
        while (!done) {
            ArrayList<T> batch = new ArrayList<T>(this.nMax);
            int i = 0;
            while (i < this.nMax) {
                T t = this.rq.poll();
                n = i++;
                if (t == null) {
                    done = i == 0;
                    break;
                }
                batch.add(t);
            }
            if (batch.size() > 0) {
                try {
                    this.exec.submit(() -> this.persistBatch(batch));
                }
                catch (RejectedExecutionException e) {
                    log.warn((Object)("max capacity, queue size " + this.rq.size() + " thread queue size " + ((ThreadPoolExecutor)this.exec).getQueue().size()), (Throwable)e);
                    this.alertService.raiseAlert(LocalDBAlert.BatchMaxCapacity.getAlert(this.persisterName, null), AlertState.WARNING, "current queue size : " + this.rq.size() + " thread queue size " + ((ThreadPoolExecutor)this.exec).getQueue().size());
                    this.rq.addAll(batch);
                }
                ++nbatch;
                boolean bl = done = this.rq.size() < this.nMax / 5;
                if (done) {
                    log.fine((Object)("run done, left in queue " + this.rq.size()));
                }
            }
            if (n <= 0) continue;
            nAcc += n;
            log.debug((Object)(this.getClass().getSimpleName() + " processed " + n + " entities."));
        }
        if (nAcc > 0) {
            long time = System.currentTimeMillis() - tstart;
            if (this.influxDbClientService != null) {
                Point.Builder batchPersisterPointBuilder = Point.measurement((String)"db_persist").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                batchPersisterPointBuilder = batchPersisterPointBuilder.addField("time_tot", time).addField("count", (long)nAcc).addField("time_avg", (double)time / (double)nAcc);
                Point point = batchPersisterPointBuilder.tag("persister", this.persisterName).tag(this.influxDbClientService.getGlobalTags()).build();
                this.influxDbClientService.getInfluxDbClient().write(point);
            } else {
                KeyValueDataList kvdl = new KeyValueDataList(this.persisterName);
                kvdl.addData(this.persisterName + "/queueProcessingTime", (Serializable)Long.valueOf(time));
                kvdl.addData(this.persisterName + "/queueSize", (Serializable)Integer.valueOf(queueAtStart));
                kvdl.addData(this.persisterName + "/nBatchInRun", (Serializable)Integer.valueOf(nbatch));
                kvdl.addData(this.persisterName + "/activeThreads", (Serializable)Integer.valueOf(((ThreadPoolExecutor)this.exec).getActiveCount()));
                kvdl.addData(this.persisterName + "/queuedTasks", (Serializable)Integer.valueOf(tasksAtStart));
                log.fine((Object)("queued tasks " + tasksAtStart + " " + ((ThreadPoolExecutor)this.exec).getQueue().size()));
                this.statusDataPersister.processEncodedData(this.a.getName(), kvdl);
            }
        }
        log.fine((Object)"end run ");
    }

    public void addToQueue(T obj) {
        this.rq.add(obj);
    }

    public abstract void persist(T var1, Session var2);
}

