/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.refrigeration;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.drivers.ametek.AvcCooler;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.common.devices.refrigeration.data.RefrigerationConfig;
import org.lsst.ccs.subsystem.common.devices.refrigeration.states.CryoDevState;
import org.lsst.ccs.utilities.logging.Logger;

public class AVCCryoDevice
extends Device {
    String serialdev;
    DriverConstants.ConnType connType = DriverConstants.ConnType.SERIAL;
    RefrigerationConfig.CryoTelType devType = null;
    private RefrigerationConfig.CryoTelType localdevType = null;
    private String localname = null;
    private static final Logger LOG = Logger.getLogger((String)AVCCryoDevice.class.getName());
    String ident;
    double T_OFFSET = 273.0;
    int baud = 9600;
    int dataChar = 0;
    private final AvcCooler AVCDRV = new AvcCooler();
    RefrigerationConfig cfg = new RefrigerationConfig();
    CryoDevState.cryostates cooler_state = CryoDevState.cryostates.NOTCONFIGURED;
    long last_disconnect = 0L;
    @ConfigurationParameter(category="Limits", units="Celsius", description="temperature at which cryotel should be shut off to avoid getting too cold")
    private volatile double temp_Min_OFF = -140.0;
    @ConfigurationParameter(category="Limits", units="Celsius", description="temperature at which the cryotel can be turned back on after auto shut-off")
    private volatile double temp_Min_ON = -120.0;
    private boolean auto_shutoff_state = false;
    private boolean commanded_on = false;
    @ConfigurationParameter(category="Cryocon", isFinal=false, units="unitless", description="proportional parameter")
    protected volatile double p_gain;
    @ConfigurationParameter(category="Cryocon", isFinal=false, units="unitless", description="integral parameter")
    protected volatile double i_gain;
    @ConfigurationParameter(category="Cryocon", isFinal=false, units="unitless", description="derivative parameter")
    protected volatile double d_gain;

    public void initDevice() {
        if (this.serialdev == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"serialdev", (String)"not specified");
        }
        this.fullName = "AVCDRV CryoTel device";
    }

    protected void initialize() {
        block2: {
            this.localname = this.name;
            this.localdevType = this.devType;
            try {
                this.AVCDRV.open(this.connType, this.serialdev, this.baud);
                this.AVCDRV.setProportional(this.p_gain);
                this.AVCDRV.setIntegral(this.i_gain);
                this.AVCDRV.setDerivative(this.d_gain);
                this.initSensors();
                this.setOnline(true);
                this.cooler_state = CryoDevState.cryostates.OK;
                LOG.info((Object)("Connected to " + this.fullName + " at " + this.serialdev + " and name " + this.name));
            }
            catch (DriverException e) {
                if (this.inited) break block2;
                LOG.error((Object)("Error connecting to " + this.fullName + " at " + this.serialdev + " and name " + this.name + ": " + (Object)((Object)e)));
            }
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.AVCDRV.close();
        }
        catch (DriverException e) {
            LOG.error((Object)("Error disconnecting from " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        if (hwChan > 7) {
            MonitorLogUtils.reportError((Logger)LOG, (String)ch.getPath(), (String)"hwChan", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        int chan = ch.getHwChan();
        if (chan == 0) {
            try {
                value = this.getTemperature();
                if (value < -270.0) {
                    value = Double.NaN;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error reading Temperature: " + e));
                value = Double.NaN;
            }
        }
        if (chan == 1) {
            try {
                value = this.getSetPoint();
            }
            catch (Exception e) {
                LOG.error((Object)("Error reading Temperature Set Point: " + e));
            }
        }
        if (chan == 2) {
            try {
                value = this.getPower();
            }
            catch (Exception e) {
                LOG.error((Object)("Error reading Power setting: " + e));
            }
        }
        if (chan == 3) {
            try {
                value = this.readPower();
            }
            catch (Exception e) {
                LOG.error((Object)("Error reading Power: " + e));
            }
        }
        if (chan == 4) {
            try {
                value = this.showAuto_shutoff_state() ? 1.0 : 0.0;
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting auto shutoff state: " + e));
            }
        }
        if (chan == 5) {
            value = this.getTemp_Min_OFF();
        }
        if (chan == 6) {
            value = this.getTemp_Min_ON();
        }
        if (chan == 7) {
            try {
                value = this.getRejectTemp();
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting reject temperature: " + e));
            }
        }
        return value;
    }

    @Command(description="Reconnect to the cooler")
    public void reconnect() {
        this.setOnline(false);
    }

    @Command(description="Show the product type")
    public String getProduct() throws DriverException {
        return this.AVCDRV.getProductType();
    }

    @Command(description="Show the firmware version")
    public String getVersion() throws DriverException {
        return this.AVCDRV.getFWVersion();
    }

    @Command(description="Show the cooler mode")
    public String getMode() throws DriverException {
        return this.AVCDRV.getMode().toString();
    }

    @Command(description="Set the cooler mode")
    public void setMode(String mode) throws DriverException {
        this.AVCDRV.setMode(AvcCooler.Mode.valueOf((String)mode));
        this.commanded_on = mode.toUpperCase().contains("ON");
        this.auto_shutoff_state = false;
    }

    @Command(description="Show the target temperature")
    public double getSetPoint() throws DriverException {
        return this.AVCDRV.getTemperature() - this.T_OFFSET;
    }

    @Command(description="Set the target temperature")
    public void setSetPoint(double temp) throws DriverException {
        this.AVCDRV.setTemperature(temp + this.T_OFFSET);
    }

    @Command(description="Get the cooler power")
    public double getPower() throws DriverException {
        return this.AVCDRV.getPower();
    }

    @Command(description="Read the cooler power")
    public double readPower() throws DriverException {
        return this.AVCDRV.readPower();
    }

    @Command(description="Set the cooler power")
    public void setPower(double pwr) throws DriverException {
        this.AVCDRV.setPower(pwr);
    }

    @Command(description="Show the temperature")
    public double getTemperature() throws DriverException {
        double temp = this.AVCDRV.readTemperature() - this.T_OFFSET;
        if (temp > -270.0) {
            if (temp < this.temp_Min_OFF && this.getMode().toUpperCase().contains("ON")) {
                this.AVCDRV.setMode(AvcCooler.Mode.valueOf((String)"OFF"));
                LOG.warning((Object)("Cryotel temperature " + temp + " C is below shutoff limit of " + this.temp_Min_OFF + " C . Cryotel mode set to OFF"));
                this.auto_shutoff_state = true;
            }
            if (temp > this.temp_Min_ON && this.getMode().toUpperCase().contains("OFF") && this.commanded_on) {
                LOG.warning((Object)("Cryotel temperature " + temp + " C is above turn on limit of " + this.temp_Min_ON + " C after an auto shutoff. Cryotel mode set to ON"));
                this.AVCDRV.setMode(AvcCooler.Mode.valueOf((String)"ON"));
                this.auto_shutoff_state = false;
            }
        } else {
            LOG.error((Object)("Invalid CryoTel Temperature: " + temp));
        }
        return temp;
    }

    @Command(description="Set cryo device status")
    public void setState(@Argument(description="State to set") int istate) {
        this.cooler_state = CryoDevState.cryostates.values()[istate];
    }

    @Command(description="Show the state of the auto shutoff")
    public boolean showAuto_shutoff_state() {
        return this.auto_shutoff_state;
    }

    @ConfigurationParameterChanger(propertyName="p_gain")
    public void setPID_prop(double pid_p) throws DriverException {
        this.p_gain = pid_p;
        if (this.isOnline()) {
            this.AVCDRV.setProportional(this.p_gain);
        }
    }

    @ConfigurationParameterChanger(propertyName="i_gain")
    public void setPID_int(double pid_i) throws DriverException {
        this.i_gain = pid_i;
        if (this.isOnline()) {
            this.AVCDRV.setIntegral(this.i_gain);
        }
    }

    @ConfigurationParameterChanger(propertyName="d_gain")
    public void setPID_deriv(double pid_d) throws DriverException {
        this.d_gain = pid_d;
        if (this.isOnline()) {
            this.AVCDRV.setDerivative(this.d_gain);
        }
    }

    @Command(description="Set cryo device status")
    public int getState() {
        return this.cooler_state.ordinal();
    }

    private static StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }

    @Command(description="Get serial dev specification")
    public String getSerialdev() {
        return this.serialdev;
    }

    @Command(description="Get device identifier")
    public String getIdent() {
        return this.ident;
    }

    @Command(description="Get cryotel state")
    public CryoDevState.cryostates getCooler_state() {
        return this.cooler_state;
    }

    @Command(description="Get temperature at which cryotel will be shutoff automatically.")
    public double getTemp_Min_OFF() {
        return this.temp_Min_OFF;
    }

    @Command(description="Set temperature at which cryotel will be shutoff automatically.")
    public String setTemp_Min_OFF(double temp_Min_OFF) {
        this.temp_Min_OFF = temp_Min_OFF;
        return "This is a configurable value that should be changed via: Ex: CryoTelCryo change temp_Min_OFF -145.";
    }

    @Command(description="Get temperature at which cryotel will be turned on automatically after an automatic shutoff.")
    public double getTemp_Min_ON() {
        return this.temp_Min_ON;
    }

    @Command(description="Set temperature at which cryotel will be turned on automatically after an automatic shutoff.")
    public String setTemp_Min_ON(double temp_Min_ON) {
        this.temp_Min_ON = temp_Min_ON;
        return "This is a configurable value that should be changed via: Ex: CryoTelCryo change temp_Min_ON -120.";
    }

    @Command(description="Return name of the device")
    public String getName() {
        return this.localname;
    }

    @Command(description="Get the most recent error")
    public int getError() throws DriverException {
        return this.AVCDRV.getError();
    }

    @Command(description="Get the most recent error")
    public double getRejectTemp() throws DriverException {
        return this.AVCDRV.readRejectTemp();
    }

    @Command(description="Return the devType")
    public RefrigerationConfig.CryoTelType getDevType() {
        return this.localdevType;
    }
}

