package org.lsst.ccs.subsystem.vacuum;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *  Handles the vacuum system simulated MPM Pluto PLC gateway.
 *
 *  @author Owen Saxton
 */
public class MpmSimPlutoDevice extends MpmPlutoDevice {

    /**
     *  Data fields.
     */
    private static final Logger LOG = Logger.getLogger(MpmSimPlutoDevice.class.getName());
    private final boolean[] switches = new boolean[NUM_SWITCHES];


    /**
     *  Performs basic initialization.
     */
    @Override
    protected void initDevice()
    {
    }


    /**
     *  Performs full initialization.
     */
    @Override
    protected void initialize()
    {
        LOG.log(Level.INFO, "Connected to simulated MPM Pluto gateway");
        setOnline(true);
    }


    /**
     *  Closes device connection.
     */
    @Override
    protected void close()
    {
    }


    /**
     *  Checks a channel's parameters for validity.
     *
     *  @param  name     The channel name
     *  @param  hwChan   The hardware channel number
     *  @param  type     The channel type string
     *  @param  subtype  The channel subtype string
     *  @return  A two-element array containing the encoded type [0] and subtype [1] values.
     */
    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype)
    {
        return new int[]{0, 0};
    }


    /**
     *  Reads all referenced channels.
     */
    @Override
    protected void readChannelGroup()
    {
    }


    /**
     *  Reads a channel.
     *
     *  @param  hwChan   The hardware channel number.
     *  @param  type     The encoded channel type returned by checkChannel.
     *  @return  The read value
     */
    @Override
    protected double readChannel(int hwChan, int type)
    {
        return 0.0;
    }


    /**
     *  Tests whether the PLC is active
     *
     *  @return  Whether the PLC is active, or null if offline
     */
    @Override
    public Boolean isPLCActive()
    {
        return true;
    }


    /**
     *  Sets a switch on or off.
     *
     *  For the vacuum Pluto, this is implemented as a pair of push buttons,
     *  one for on, one for off.
     *
     *  @param  sw  The switch number.
     *  @param  on  The on state to set: true or false
     */
    @Override
    public void setSwitch(int sw, boolean on)
    {
        switches[sw] = on;
    }


    /**
     *  Gets the on state of a switch.
     *
     *  The state is not the state of the bit that was toggled, but is read back
     *  either directly from the controlled hardware, or from the PLC output line.
     *
     *  @param  sw  The switch number.
     *  @return  Whether the switch is on
     */
    @Override
    public Boolean isSwitchOn(int sw)
    {
        return switches[sw];
    }

}
