package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.vacuum.constants.Devices;

/**
 * Device class which identifies a vacuum gauge
 * 
 * @author CCS team
 */
public class VacMksDevice  extends Mks9xxDevice implements SwitchDevice {

    private int deviceId = Devices.DEVC_NO_SWITCH;  // Set in Groovy file

    private volatile long ccAutoPowerTimeStamp = 0;
    private volatile Boolean ccAutoPowerState = null;
    private volatile long ccAutoPowerMaxAge = 100000;  // ms

    /**
     *  Gets the switch device ID.
     * 
     *  @return  The device ID
     */
    @Override
    public int getSwitchDevice()
    {
        return deviceId;
    }


    /**
     *  Turns a switch on or off.
     * 
     *  @param  sw  The switch ID
     *  @param  on  Whether to turn on or off
     *  @throws  DriverException
     */
    @Override
    public void setSwitch(int sw, boolean on) throws DriverException
    {
        if (on) {
            setLock(false);
            setCCAutoPower(true);
            setLock(true);
        }
        else {
            setLock(false);
            setCCAutoPower(false);
            setLock(true);
        }
        ccAutoPowerState = isCCAutoPowerOn();
        ccAutoPowerTimeStamp = System.currentTimeMillis();
    }


    /**
     *  Gets whether a switch is on.
     * 
     *  @param  sw  The switch ID
     *  @return  Whether on, or null if device is offline
     */
    @Override
    public Boolean isSwitchOn(int sw)
    {
        if (System.currentTimeMillis() - ccAutoPowerTimeStamp > ccAutoPowerMaxAge) {
            try {
                ccAutoPowerState = isCCAutoPowerOn();
                ccAutoPowerTimeStamp = System.currentTimeMillis();
            }
            catch (DriverException e) {
                return null;
            }
        }
        return ccAutoPowerState;
    }
    
}
