package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;

import org.lsst.ccs.drivers.commons.DriverException;

import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.DerivedChannel;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;
import org.lsst.ccs.subsystem.vacuum.constants.Devices;

/**
 *  Handles the vacuum system MAQ20 device with monitoring of limit switches for foreline valve.
 *
 *  @author CCS
 */
//public class FlineValvePositions extends Maq20Device implements HasLifecycle {
public class FlineValvePositions extends DerivedChannel implements HasLifecycle {

    /**
     *  Constants.
     */
    

    //    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected Maq20DiscControl ValveLimitSwitches;
    //    protected VacMaq20Device ValveLimitSwitches;

    @LookupPath
    private String path;
 
    /**
     *  Initialization.
     */
    @Override
    public void init()
    {
	//        super.init();
        if (ValveLimitSwitches == null) {
            throw new RuntimeException(path + ": Maq20DiscControl node has not been defined");
        }
    }


    /**
     *  Gets the on state of a limit switch line
     *
     *  @param  line  The line number.
     *  @return  Whether the line is active
     */
    @Command(type = Command.CommandType.QUERY)
    public Boolean isSwitchOn(@Argument(description=
					"\nForeline valve limit switch line number:\n" +
					" CRYO_FLINE_VALVE_OPEN:"+VacMaq20Device.CRYO_FLINE_VALVE_OPEN+"\n"+
					" CRYO_FLINE_VALVE_CLOSED:"+VacMaq20Device.CRYO_FLINE_VALVE_CLOSED+"\n"+
					" HX_FLINE_VALVE_OPEN:"+VacMaq20Device.HX_FLINE_VALVE_OPEN+"\n"+
					" HX_FLINE_VALVE_CLOSED:"+VacMaq20Device.HX_FLINE_VALVE_CLOSED+"\n"
					) int line)
    {
	return(false); // disabled until we have tested this action
	//	return ValveLimitSwitches.isLimitSwitchOn(line);
    }

    @Override
    public double evaluateDerivedValue()
    {

	double val = -1.0;
	/* disabled until problems resolved
	try {
	    val = 1.0 * (
		       ((isLimitSwitchOn(VacMaq20Device.CRYO_FLINE_VALVE_OPEN) ? 1 : 0)   << 3) +
		       ((isLimitSwitchOn(VacMaq20Device.CRYO_FLINE_VALVE_CLOSED) ? 1 : 0) << 2) +
		       ((isLimitSwitchOn(VacMaq20Device.HX_FLINE_VALVE_OPEN) ? 1 : 0)     << 1) +
		       ((isLimitSwitchOn(VacMaq20Device.HX_FLINE_VALVE_CLOSED) ? 1 : 0) )
		       );
	}
	catch (RuntimeException e) {
	    val = -1.0;
	    //            throw new RuntimeException(path + ": Maq20DiscControl node unable to read valve positions");
	}
	*/
	return(val);
    }

}
