/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;
import org.lsst.ccs.subsystem.common.devices.dataforth.SimMaq20Device;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;

public class VacSimMaq20Device
extends SimMaq20Device
implements SwitchDevice {
    public static final int SW_INST_FTPP_VALVE = 0;
    public static final int SW_INST_FTH_VALVE = 1;
    public static final int SW_INST_L3H_VALVE = 2;
    public static final int SW_INST_L3LF_VALVE = 3;
    public static final int SW_INST_FLINE_VALVE = 4;
    public static final int SW_CRYO_FLINE_VALVE = 5;
    public static final int SW_HX_FLINE_VALVE = 6;
    public static final int NUM_SWITCHES = 7;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected Maq20DiscControl maqCtrl;

    protected void initDevice() {
        super.initDevice();
        if (this.maqCtrl == null) {
            throw new RuntimeException(this.path + ": Child Maq20DiscControl node has not been defined");
        }
    }

    @Override
    public int getSwitchDevice() {
        return 9;
    }

    @Override
    public void setSwitch(int sw, boolean on) throws DriverException {
        this.maqCtrl.setLineOn(sw, on);
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.maqCtrl.isLineOn(sw);
    }
}

