/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pfeiffer.ASM380;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;

public class ASM380Device
extends Device {
    @ConfigurationParameter(name="devcId", category="Cryo", isFinal=true)
    private volatile String devcId;
    private final DriverConstants.ConnType connType = DriverConstants.ConnType.SERIAL;
    private final int baudRate = 9600;
    private static final Logger LOG = Logger.getLogger(ASM380Device.class.getName());
    private final ASM380 mydev = new ASM380();
    private int errorCount = 0;
    private boolean initError = false;
    private final Map<String, Boolean> activeAlerts = new HashMap<String, Boolean>();

    public void initDevice() {
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "ASM380";
    }

    public void initialize() {
        try {
            this.mydev.open(this.connType, this.devcId, 9600, 0);
            this.errorCount = 0;
            LOG.log(Level.INFO, "Connected to {0}", new Object[]{this.fullName});
            this.initError = false;
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.mydev.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    public void close() {
        try {
            this.mydev.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    public double readChannel(Channel ch) {
        double value = Double.NaN;
        if (this.isOnline()) {
            switch (ch.getHwChan()) {
                case 0: {
                    try {
                        value = this.mydev.readInletPressure();
                        this.errorCount = 0;
                    }
                    catch (DriverException e) {
                        LOG.log(Level.SEVERE, "Error reading pressure from {0}: {1}", new Object[]{this.fullName, e});
                        if (++this.errorCount < 5) break;
                        this.setOnline(false);
                    }
                    break;
                }
                case 1: {
                    try {
                        value = this.getPumpStatus().contains("on") ? 1.0 : 0.0;
                        this.errorCount = 0;
                    }
                    catch (DriverException e) {
                        LOG.log(Level.SEVERE, "Error reading pump cycle enabled status from {0}: {1}", new Object[]{this.fullName, e});
                        if (++this.errorCount < 5) break;
                        this.setOnline(false);
                    }
                    break;
                }
                case 2: {
                    try {
                        value = this.mydev.readTemperature();
                        this.errorCount = 0;
                    }
                    catch (DriverException e) {
                        LOG.log(Level.SEVERE, "Error reading temperature from {0}: {1}", new Object[]{this.fullName, e});
                        if (++this.errorCount < 5) break;
                        this.setOnline(false);
                    }
                    break;
                }
                case 4: {
                    try {
                        value = this.getVentValveStatus().contains("open") ? 1.0 : 0.0;
                        this.errorCount = 0;
                        break;
                    }
                    catch (DriverException e) {
                        LOG.log(Level.SEVERE, "Error reading venting status from {0}: {1}", new Object[]{this.fullName, e});
                        if (++this.errorCount < 5) break;
                        this.setOnline(false);
                    }
                }
            }
        }
        return value;
    }

    @Command(description="Show the version string")
    public String showVersion() throws DriverException {
        return this.mydev.getVersion();
    }

    @Command(description="Show the instrument status")
    public String showStatus() throws DriverException {
        return String.format("0x%04x", this.mydev.getStatus());
    }

    @Command(description="Show the decoded instrument status")
    public String showDecodedStatus() throws DriverException {
        String[] status = this.mydev.decodeStatus();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < status.length; ++j) {
            if (j != 0) {
                text.append("\n");
            }
            text.append(status[j]);
        }
        return text.toString();
    }

    @Command(description="Read the inlet pressure")
    public double readInletPressure() throws DriverException {
        return this.mydev.readInletPressure();
    }

    @Command(description="Read the temperature")
    public int readTemperature() throws DriverException {
        return this.mydev.readTemperature();
    }

    @Command(description="Show the primary pump operating hours")
    public int showPrimaryHours() throws DriverException {
        return this.mydev.getPrimaryHours();
    }

    @Command(description="Show the high vacuum pump operating hours")
    public int showHighVacHours() throws DriverException {
        return this.mydev.getHighVacHours();
    }

    @Command(description="Show the stored warning codes")
    public String showWarningCodes() throws DriverException {
        return ASM380Device.showCodes(this.mydev.getWarningCodes());
    }

    @Command(description="Show the stored fault codes")
    public String showFaultCodes() throws DriverException {
        return ASM380Device.showCodes(this.mydev.getFaultCodes());
    }

    private static String showCodes(int[] codes) {
        if (codes.length == 0) {
            return "No codes stored";
        }
        StringBuilder text = new StringBuilder();
        for (int code : codes) {
            text.append(code).append(" ");
        }
        return text.toString();
    }

    @Command(description="Clear the stored warning codes")
    public void clearWarnings() throws DriverException {
        this.mydev.clearWarnings();
    }

    @Command(description="Clear the stored fault codes")
    public void clearFaults() throws DriverException {
        this.mydev.clearFaults();
    }

    @Command(description="set pump on (true) or off (false)")
    public void pumpOn(boolean on) throws DriverException {
        if (!this.getVentValveStatus().contains("closed")) {
            LOG.log(Level.SEVERE, "Rejected attempt to turn pumping on with the valve open.");
        } else {
            this.mydev.pumpOn(on);
        }
    }

    @Command(description="get the pumping status")
    public String getPumpStatus() throws DriverException {
        return this.mydev.getPumpStatus();
    }

    @Command(description="execute open vent sequence")
    public void openVentValve(boolean open) throws DriverException {
        this.mydev.setVentValveNominal();
        this.mydev.openVentValve(open);
    }

    @Command(description="get the venting status")
    public String getVentValveStatus() throws DriverException {
        return this.mydev.getVentValveStatus();
    }

    @Command(description="get the venting valve actuation parameters")
    public String getVentValveParms() throws DriverException {
        return this.mydev.getVentValveParms();
    }

    @Command(description="setup venting sequence")
    public void setVentValveParms(@Argument(description="delay before actuation (0->2 secs)") int delay, @Argument(description="time (secs) in open state") int period) throws DriverException {
        this.mydev.setVentValveParms(delay, period);
    }

    @Command(description="execute pulse vent sequence")
    public void pulseVentValve(@Argument(description="time (secs) in open state") int seconds) throws DriverException {
        this.mydev.setVentValveParms(0, seconds);
        this.mydev.openVentValve(true);
        try {
            Thread.sleep(1000 * (seconds + 1));
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "Interrupted!! Prematurely stopping the pumping" + ex);
        }
        this.mydev.setVentValveNominal();
    }

    @Command(description="execute pulse cycling/pumping")
    public void pulsePump(@Argument(description="time (secs) in pumping state") int seconds) throws DriverException {
        this.mydev.pumpOn(true);
        try {
            Thread.sleep(1000 * seconds);
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "Interrupted!! Prematurely stopping the pumping" + ex);
        }
        this.mydev.pumpOn(false);
    }

    @Command(description="set venting sequence nominal")
    public void setVentValveNominal() throws DriverException {
        this.mydev.setVentValveNominal();
    }

    @Command(description="Write a command")
    public String writeCommand(@Argument(description="The commmand to send") String command) throws DriverException {
        return this.mydev.writeCommand(command);
    }

    private void raiseAlarm(Alert alert, String cause) {
        Boolean active = this.activeAlerts.get(alert.getAlertId());
        if (active != Boolean.TRUE) {
            this.alertService.raiseAlert(alert, AlertState.ALARM, cause);
            this.activeAlerts.put(alert.getAlertId(), true);
        }
    }

    private void lowerAlarm(Alert alert, String cause) {
        Boolean active = this.activeAlerts.get(alert.getAlertId());
        if (active == Boolean.TRUE) {
            this.alertService.raiseAlert(alert, AlertState.NOMINAL, cause);
            this.activeAlerts.put(alert.getAlertId(), false);
        }
    }

    public DeviceState getDeviceState() {
        try {
            if (!this.isOnline()) {
                return DeviceState.OFFLINE;
            }
            if (this.getPumpStatus().contains("on")) {
                return DeviceState.NORMAL;
            }
            if (this.getPumpStatus().contains("off")) {
                return DeviceState.STOPPED;
            }
            return DeviceState.TRANSIT;
        }
        catch (DriverException e) {
            return null;
        }
    }
}

