/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;

@Entity
@Table(indexes={@Index(columnList="binWidth,startTime"), @Index(columnList="endTime")}, uniqueConstraints={@UniqueConstraint(columnNames={"startTime", "binWidth"})})
@Cacheable
@Immutable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY, region="org.lsst.ccs.localdb.statusdb.model.StatTimeInterval")
@NaturalIdCache
public class StatTimeInterval
implements Serializable {
    private static final long serialVersionUID = 7128231906408578843L;
    private long id;
    private long startTime;
    private long binWidth;
    private long endTime;

    public StatTimeInterval() {
    }

    public StatTimeInterval(long startTime, long binWidth) {
        this.startTime = startTime;
        this.binWidth = binWidth;
        this.endTime = startTime + binWidth;
    }

    @Id
    @GeneratedValue(generator="ID_SEQUENCE_GENERATOR")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @NaturalId(mutable=false)
    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @NaturalId(mutable=false)
    public long getBinWidth() {
        return this.binWidth;
    }

    public void setBinWidth(long binWidth) {
        this.binWidth = binWidth;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (int)(this.getStartTime() ^ this.getStartTime() >>> 32);
        hash = 47 * hash + (int)(this.getBinWidth() ^ this.getBinWidth() >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatTimeInterval)) {
            return false;
        }
        StatTimeInterval other = (StatTimeInterval)obj;
        return this.getStartTime() == other.getStartTime() && this.getBinWidth() == other.getBinWidth();
    }
}

