/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.Iterator;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.LTC2945;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class PduCommon
extends Srp {
    protected static final int REG_DEVICE_BASE = 65536;
    protected static final int REG_SWITCHES = 65536;
    protected static final int REG_MAIN_SWITCH = 65537;
    protected static final int REG_MAIN_STATUS = 65538;
    protected static final int REG_ALERTS = 65539;
    protected static final int REG_LINK_FAULT = 65540;
    protected static final int REG_ADC_BASE = 66560;
    private int validChanMask;
    private double[] currentScales;
    private Map<String, Integer> channelMap;
    private String[] channelNames;
    private final LTC2945 adc = new LTC2945(this, 66560);

    protected void setValidChannels(int chans) {
        this.validChanMask = chans;
    }

    public int getValidChannels() {
        return this.validChanMask;
    }

    protected void setCurrentScales(double[] scales) {
        this.currentScales = scales;
    }

    protected void setChannelMap(Map chans) {
        this.channelMap = chans;
        int maxChan = -1;
        Iterator<Object> iterator = this.channelMap.values().iterator();
        while (iterator.hasNext()) {
            int chan = iterator.next();
            maxChan = Math.max(maxChan, chan);
        }
        this.channelNames = new String[maxChan + 1];
        iterator = this.channelMap.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            this.channelNames[this.channelMap.get((Object)name).intValue()] = name = (String)iterator.next();
        }
    }

    public String[] getChannelNames() {
        return this.channelNames;
    }

    public void setMainOn() throws DriverException {
        this.writeReg(65537, 1);
    }

    public void setMainOff() throws DriverException {
        this.writeReg(65537, 0);
    }

    public boolean isMainOn() throws DriverException {
        return (this.readReg(65537) & 1) != 0;
    }

    public int getMainStatus() throws DriverException {
        return this.readReg(65538);
    }

    public void powerOn(int chan) throws DriverException {
        this.updateReg(65536, 1 << this.checkChannelNumber(chan), -1);
    }

    public void powerOn(String chan) throws DriverException {
        this.updateReg(65536, 1 << this.getChannelNumber(chan), -1);
    }

    public void powerOff(int chan) throws DriverException {
        this.updateReg(65536, 1 << this.checkChannelNumber(chan), 0);
    }

    public void powerOff(String chan) throws DriverException {
        this.updateReg(65536, 1 << this.getChannelNumber(chan), 0);
    }

    public int getPoweredStatus() throws DriverException {
        return this.readReg(65536);
    }

    public boolean isPowered(int chan) throws DriverException {
        return (this.readReg(65536) >> this.checkChannelNumber(chan) & 1) != 0;
    }

    public boolean isPowered(String chan) throws DriverException {
        return (this.readReg(65536) >> this.getChannelNumber(chan) & 1) != 0;
    }

    public int getAlertStatus() throws DriverException {
        return this.readReg(65539);
    }

    public boolean hasAlert(int chan) throws DriverException {
        return (this.readReg(65539) >> this.checkChannelNumber(chan) & 1) != 0;
    }

    public boolean hasAlert(String chan) throws DriverException {
        return (this.readReg(65539) >> this.getChannelNumber(chan) & 1) != 0;
    }

    public void clearAlert(int chan) throws DriverException {
        this.writeReg(65539, 1 << this.checkChannelNumber(chan));
    }

    public void clearAlert(String chan) throws DriverException {
        this.writeReg(65539, 1 << this.getChannelNumber(chan));
    }

    public void clearAlerts() throws DriverException {
        this.writeReg(65539, -1);
    }

    public int getLinkFault() throws DriverException {
        return this.readReg(65540);
    }

    public double readVoltage(int chan) throws DriverException {
        return this.adc.readVoltage(this.checkChannelNumber(chan));
    }

    public double readVoltage(String chan) throws DriverException {
        return this.adc.readVoltage(this.getChannelNumber(chan));
    }

    public double readCurrent(int chan) throws DriverException {
        return this.adc.readCurrent(this.checkChannelNumber(chan)) * this.currentScales[chan];
    }

    public double readCurrent(String chan) throws DriverException {
        int cnum = this.getChannelNumber(chan);
        return this.adc.readCurrent(cnum) * this.currentScales[cnum];
    }

    private int checkChannelNumber(int chan) throws DriverException {
        if (chan < 0 || (1 << chan & this.validChanMask) == 0) {
            throw new DriverException("Invalid channel number: " + chan);
        }
        return chan;
    }

    private int getChannelNumber(String chan) throws DriverException {
        Integer cnum = this.channelMap.get(chan);
        if (cnum == null) {
            throw new DriverException("Invalid channel name: " + chan);
        }
        return cnum;
    }
}

