/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import java.util.Date;
import java.util.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.PeriodicTaskExceptionHandler;

public final class Scheduler
implements Executor {
    static final Timer TIMER = new Timer("Scheduler.Timer", true);
    private final String name;
    final ScheduledThreadPoolExecutor executor;
    volatile Logger log;
    volatile int maxFailures = 10;
    private volatile Level defaultLogLevel = Level.WARNING;

    public Scheduler(String name, int nThreads) {
        this.name = name;
        this.executor = new ScheduledThreadPoolExecutor(nThreads, r -> new Thread(r, name));
        this.executor.setRemoveOnCancelPolicy(true);
    }

    public Scheduler(String name, int nThreads, ThreadGroup threadGroup) {
        this.name = name;
        this.executor = new ScheduledThreadPoolExecutor(nThreads, r -> new Thread(threadGroup, r, name));
        this.executor.setRemoveOnCancelPolicy(true);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void setDefaultLogLevel(Level defaultLogLevel) {
        this.defaultLogLevel = defaultLogLevel;
    }

    public void setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public String getName() {
        return this.name;
    }

    public Level getDefaultLogLevel() {
        return this.defaultLogLevel;
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(command, delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, Date date) {
        return this.executor.schedule(command, date.getTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executor.schedule(callable, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, Date date) {
        return this.executor.schedule(callable, date.getTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public PeriodicTask scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit, String taskName, PeriodicTaskExceptionHandler exceptionHandler) {
        PeriodicTask task = new PeriodicTask(this, command, true, taskName, period, unit, exceptionHandler);
        task.start(initialDelay, unit);
        return task;
    }

    public PeriodicTask scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit, String taskName, Level logLevel) {
        PeriodicTask task = new PeriodicTask(this, command, true, taskName, logLevel, period, unit);
        task.start(initialDelay, unit);
        return task;
    }

    public PeriodicTask scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleAtFixedRate(command, initialDelay, period, unit, "", this.defaultLogLevel);
    }

    public PeriodicTask scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit, String taskName, Level logLevel) {
        PeriodicTask task = new PeriodicTask(this, command, false, taskName, logLevel, delay, unit);
        task.start(initialDelay, unit);
        return task;
    }

    public PeriodicTask scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduleWithFixedDelay(command, initialDelay, delay, unit, "", this.defaultLogLevel);
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public int getQueueSize() {
        return this.executor.getQueue().size();
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }
}

