/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.vacuum.CryoTurboDevice;
import org.lsst.ccs.subsystem.vacuum.HxTurboDevice;
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchInfo;
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.Devices;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.constants.VacuumAlert;
import org.lsst.ccs.subsystem.vacuum.constants.VacuumState;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;
import org.lsst.ccs.subsystem.vacuum.data.VacuumException;

public class VacuumMain
extends Subsystem
implements HasLifecycle,
ClearAlertHandler,
AlertListener {
    private static final double PRESS_ATMOS = 759.0;
    private static final double PRESS_TURBO_LOW = 5.0;
    private static final double PRESS_FORELINE_LOW = 5.0;
    private static final double PRESS_DIFF_LOW = 0.09;
    private static final double PRESS_DIFF_HIGH = 20.0;
    private static final double PRESS_ION_OFF = 1.1E-5;
    private static final double PRESS_ION_ENABLE = 1.0E-6;
    private static final double PRESS_VACUUM = 1.0E-7;
    private static final double TURBO_MAX = 60000.0;
    private static final double TURBO_LOW = 6000.0;
    private static final int MAX_PRESS_ERRORS = 3;
    private static final int MAX_SPEED_ERRORS = 0;
    private static final int DELAY_ION_OFF = 10000;
    private static final Map<Integer, VacuumAlert> alertMap = new HashMap<Integer, VacuumAlert>();
    private static final Map<String, Integer> revAlertMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<SwitchDevice> switches = new ArrayList<SwitchDevice>();
    private Channel cryoVacPressure;
    private Channel cryoTurboPressure;
    private Channel cryoFlinePressure;
    private Channel cryoTurboSpeed;
    private Channel hxVacPressure;
    private Channel hxTurboPressure;
    private Channel hxFlinePressure;
    private Channel hxTurboSpeed;
    private Channel orVacPressure;
    private static final Logger LOG;
    private MonitorTaskControl monitorControl;
    private final SwitchDevice[] switchDevices = new SwitchDevice[5];
    private VacPlutoDevice plutoDevc;
    private IonPumpDevice ionPumpDevc;
    private CryoTurboDevice cryoTurboDevc;
    private HxTurboDevice hxTurboDevc;
    private final VacSysState vacState = new VacSysState();
    private boolean running = false;
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private long ionOverStartTime = 0L;
    private double forelinePress;
    private double turboPress;
    private double cryoPress;
    private double turboSpd;
    private int forelinePrErrs;
    private int turboPrErrs;
    private int cryoPrErrs;
    private int turboSpErrs;

    public VacuumMain() {
        super("vacuum", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("vacuum-state", () -> this.updateVacuumState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        this.stateService.registerState(VacuumState.class, "Vacuum state", (Object)this);
        this.stateService.updateAgentState(new Enum[]{VacuumState.UNKNOWN});
        for (VacuumAlert alert : VacuumAlert.values()) {
            this.activeAlertMap.put(alert.getId(), false);
        }
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("vacuumType", VacuumMain.class.getCanonicalName());
        this.alertService.addListener((AlertListener)this);
        Iterator<SwitchDevice> iterator = this.switches.iterator();
        while (iterator.hasNext()) {
            SwitchDevice device;
            this.switchDevices[device.getSwitchDevice()] = device = iterator.next();
        }
        for (int id = 0; id < 5; ++id) {
            if (this.switchDevices[id] != null) continue;
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)(Devices.getDescription(id) + " device"), (String)"not defined");
        }
        this.plutoDevc = (VacPlutoDevice)this.switchDevices[0];
        this.ionPumpDevc = (IonPumpDevice)this.switchDevices[1];
        this.cryoTurboDevc = (CryoTurboDevice)this.switchDevices[2];
        this.hxTurboDevc = (HxTurboDevice)this.switchDevices[3];
        if (this.cryoFlinePressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo foreline pressure channel", (String)"not specified");
        }
        if (this.cryoVacPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo vacuum pressure channel", (String)"not specified");
        }
        if (this.cryoTurboPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo turbo pump pressure channel", (String)"not specified");
        }
        if (this.cryoTurboSpeed == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo turbo pump speed channel", (String)"not specified");
        }
        if (this.hxFlinePressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"HX foreline pressure channel", (String)"not specified");
        }
        if (this.hxVacPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"HX vacuum pressure channel", (String)"not specified");
        }
        if (this.hxTurboPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"HX turbo pump pressure channel", (String)"not specified");
        }
        if (this.hxTurboSpeed == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"HX turbo pump speed channel", (String)"not specified");
        }
        if (this.orVacPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"O-ring vacuum pressure channel", (String)"not specified");
        }
        this.ionPumpDevc.setCryoPressureChannel(this.cryoVacPressure);
        this.ionPumpDevc.setHxPressureChannel(this.hxVacPressure);
    }

    public void postStart() {
        LOG.info("Vacuum subsystem started");
        this.running = true;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the vacuum system state", level=0)
    public VacSysState getVacuumState() {
        this.vacState.setTickMillis(this.monitorControl.getPublishPeriod());
        return this.vacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names", level=0)
    public List<String> getSwitchNames() throws VacuumException {
        return Switches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        try {
            this.setSwitch(Switches.getId(name), on);
        }
        finally {
            this.publishState();
        }
    }

    private void setSwitch(int sw, boolean on) throws VacuumException {
        SwitchState state = this.vacState.getSwitchState(sw);
        if (state == SwitchState.OFFLINE) {
            return;
        }
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        if (on && enable != SwitchEnable.ON) {
            return;
        }
        try {
            this.switchDevices[Switches.getDevice(sw)].setSwitch(SwitchInfo.getSwitch(sw), on);
        }
        catch (DriverException e) {
            throw new VacuumException("Error setting switch for " + Devices.getDescription(Switches.getDevice(sw)) + " device: " + (Object)((Object)e));
        }
    }

    private Boolean isSwitchOn(int sw) {
        return this.switchDevices[Switches.getDevice(sw)].isSwitchOn(SwitchInfo.getSwitch(sw));
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a condition")
    public void clearLatch(@Argument(description="The condition number") int cond) throws VacuumException {
        try {
            this.plutoDevc.clearLatch(cond);
        }
        finally {
            this.publishState();
        }
    }

    private void updateVacuumState() {
        Boolean active;
        int cond;
        double forelinePr;
        if (!this.running) {
            return;
        }
        Boolean plcActive = this.plutoDevc.isPLCActive();
        if (plcActive == null) {
            if (this.vacState.getPlcState() != PLCState.OFFLINE) {
                this.raiseAlert(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is offline");
                this.vacState.setPlcState(PLCState.OFFLINE);
            }
        } else if (!plcActive.booleanValue()) {
            if (this.vacState.getPlcState() != PLCState.DEAD) {
                this.raiseAlert(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC has died");
                this.vacState.setPlcState(PLCState.DEAD);
            }
        } else if (this.vacState.getPlcState() != PLCState.ALIVE) {
            this.lowerAlert(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is alive");
            this.vacState.setPlcState(PLCState.ALIVE);
        }
        if (!Double.isNaN(forelinePr = this.cryoFlinePressure.getValue())) {
            this.forelinePress = forelinePr;
            this.forelinePrErrs = 0;
        } else if (this.forelinePrErrs++ < 3) {
            forelinePr = this.forelinePress;
        }
        double cryoPr = this.cryoVacPressure.getValue();
        if (!Double.isNaN(cryoPr)) {
            this.cryoPress = cryoPr;
            this.cryoPrErrs = 0;
        } else if (this.cryoPrErrs++ < 3) {
            cryoPr = this.cryoPress;
        }
        double turboPr = this.cryoTurboPressure.getValue();
        if (!Double.isNaN(turboPr)) {
            this.turboPress = turboPr;
            this.turboPrErrs = 0;
        } else if (this.turboPrErrs++ < 3) {
            turboPr = this.turboPress;
        }
        double turboSp = this.cryoTurboSpeed.getValue();
        if (!Double.isNaN(turboSp)) {
            this.turboSpd = turboSp;
            this.turboSpErrs = 0;
        } else if (this.turboSpErrs++ < 0) {
            turboSp = this.turboSpd;
        }
        boolean changed = this.monitorControl.hasPeriodChanged();
        for (int sw = 0; sw < 19; ++sw) {
            SwitchEnable enabled;
            Boolean isOn;
            Boolean enable = false;
            boolean turnOff = false;
            DeviceState devState = null;
            VacuumAlert alert = null;
            switch (sw) {
                case 7: {
                    boolean cryoTurbAvail;
                    alert = VacuumAlert.CRYO_GATE_CLOSED;
                    boolean bl = cryoTurbAvail = !Double.isNaN(cryoPr) && !Double.isNaN(turboPr) && !Double.isNaN(turboSp);
                    if (cryoTurbAvail) {
                        double prDiff = Math.abs(turboPr - cryoPr);
                        enable = prDiff <= 20.0 && turboSp <= 6000.0 || prDiff <= 0.09 && turboSp > 6000.0;
                    }
                    boolean enable2 = cryoTurbAvail && !Double.isNaN(forelinePr) && (forelinePr < 5.0 || turboSp <= 6000.0);
                    enable = enable & enable2;
                    turnOff = !enable2;
                    break;
                }
                case 0: {
                    alert = VacuumAlert.CRYO_TURBO_PUMP_STOPPED;
                    if (!(Double.isNaN(turboPr) || Double.isNaN(forelinePr) || Double.isNaN(turboSp))) {
                        enable = turboPr < 5.0 && (forelinePr < 5.0 || turboSp < 6000.0);
                    }
                    turnOff = enable == false;
                    devState = this.cryoTurboDevc.getDeviceState();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    alert = VacuumAlert.CRYO_ION_PUMPS_STOPPED;
                    if (!Double.isNaN(cryoPr)) {
                        enable = cryoPr < 1.0E-6;
                        if (cryoPr >= 1.1E-5) {
                            if (this.ionOverStartTime == 0L) {
                                this.ionOverStartTime = System.currentTimeMillis();
                                break;
                            }
                            turnOff = System.currentTimeMillis() - this.ionOverStartTime >= 10000L;
                            break;
                        }
                        this.ionOverStartTime = 0L;
                        break;
                    }
                    turnOff = true;
                    break;
                }
                case 8: 
                case 13: 
                case 18: {
                    enable = true;
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    enable = true;
                }
            }
            SwitchState oldState = this.vacState.getSwitchState(sw);
            if (turnOff && oldState == SwitchState.ON) {
                try {
                    this.setSwitch(sw, false);
                    this.raiseAlert(alert, "Switch was forced to open");
                }
                catch (VacuumException e) {
                    LOG.log(Level.SEVERE, "Error setting switch: {0}", e);
                }
            }
            SwitchState state = (isOn = this.isSwitchOn(sw)) != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : SwitchState.OFFLINE;
            SwitchEnable switchEnable = enabled = enable != false ? SwitchEnable.ON : SwitchEnable.OFF;
            if (state != oldState || enabled != this.vacState.getSwitchEnable(sw)) {
                this.vacState.setSwitchState(sw, state);
                this.vacState.setSwitchEnable(sw, enabled);
                changed = true;
                if (enable.booleanValue() && alert != null && this.isAlertRaised(alert)) {
                    this.lowerAlert(alert, "Switch has become re-enabled");
                }
            }
            if (devState == this.vacState.getDeviceState(sw)) continue;
            this.vacState.setDeviceState(sw, devState);
            changed = true;
        }
        for (cond = 0; cond < 8; ++cond) {
            LatchState oldState;
            active = this.plutoDevc.isLatchActive(cond);
            Boolean latched = this.plutoDevc.isLatchLatched(cond);
            LatchState state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR));
            if (state == (oldState = this.vacState.getLatch(cond))) continue;
            this.vacState.setLatch(cond, state);
            VacuumAlert alert = alertMap.get(cond);
            if (state == LatchState.ACTIVE) {
                this.raiseAlert(alert, "Vacuum PLC error condition set");
            } else if (state != LatchState.OFFLINE && oldState != LatchState.OFFLINE) {
                if (state == LatchState.LATCHED && oldState == LatchState.CLEAR) {
                    this.raiseAlert(alert, "Vacuum PLC error condition set");
                }
                if (state == LatchState.LATCHED || oldState == LatchState.ACTIVE) {
                    this.lowerAlert(alert, "Vacuum PLC error condition cleared");
                }
            }
            changed = true;
        }
        for (cond = 0; cond < 10; ++cond) {
            ConditionState state;
            active = this.plutoDevc.isConditionActive(cond);
            ConditionState conditionState = active == null ? ConditionState.OFF : (state = active != false ? ConditionState.YES : ConditionState.NO);
            if (state == this.vacState.getCondition(cond)) continue;
            this.vacState.setCondition(cond, state);
            changed = true;
        }
        VacuumState vState = Double.isNaN(cryoPr) ? VacuumState.UNKNOWN : (cryoPr <= 1.0E-7 ? VacuumState.VACUUM : (this.vacState.getSwitchState(1) == SwitchState.ON ? VacuumState.ION_ON : (this.vacState.getSwitchEnable(1) == SwitchEnable.ON ? VacuumState.ION_OFF : (this.vacState.getSwitchState(0) == SwitchState.ON ? VacuumState.TURBO_ON : (this.vacState.getSwitchEnable(0) == SwitchEnable.ON ? VacuumState.TURBO_OFF : (cryoPr < 759.0 ? VacuumState.FORELINE : VacuumState.OFF))))));
        if (vState != this.vacState.getVacuumState()) {
            this.vacState.setVacuumState(vState);
            this.stateService.updateAgentState(new Enum[]{vState});
            changed = true;
        }
        if (changed) {
            this.publishState();
        }
    }

    private void raiseAlert(VacuumAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.ALARM, cond);
        this.activeAlertMap.put(alert.getId(), true);
    }

    private boolean isAlertRaised(VacuumAlert alert) {
        return this.activeAlertMap.get(alert.getId()).equals(Boolean.TRUE);
    }

    private void lowerAlert(VacuumAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.NOMINAL, cond);
        this.activeAlertMap.put(alert.getId(), false);
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        Boolean active = this.activeAlertMap.get(alert.getAlertId());
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            Integer cond = revAlertMap.get(id);
            if (cond == null) continue;
            try {
                this.clearLatch(cond);
            }
            catch (VacuumException e) {
                LOG.log(Level.SEVERE, "Error clearing latched PLC condition ({0}): {1}", new Object[]{cond, e});
            }
        }
    }

    private void publishState() {
        this.publishSubsystemDataOnStatusBus(new KeyValueData("VacuumState", (Serializable)this.getVacuumState()));
    }

    static {
        alertMap.put(0, VacuumAlert.CRYO_VACUUM_BAD);
        alertMap.put(1, VacuumAlert.CRYO_GATE_FORCED_SHUT);
        alertMap.put(2, VacuumAlert.CRYO_GATE_CANNOT_OPEN);
        alertMap.put(3, VacuumAlert.CRYO_TURBO_PUMP_BAD);
        alertMap.put(4, VacuumAlert.HX_VACUUM_BAD);
        alertMap.put(5, VacuumAlert.HX_GATE_FORCED_SHUT);
        alertMap.put(6, VacuumAlert.HX_GATE_CANNOT_OPEN);
        alertMap.put(7, VacuumAlert.HX_TURBO_PUMP_BAD);
        revAlertMap = new HashMap<String, Integer>();
        for (int cond : alertMap.keySet()) {
            revAlertMap.put(alertMap.get(cond).getId(), cond);
        }
        LOG = Logger.getLogger(VacuumMain.class.getName());
    }
}

