/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.ascii.Multidrop;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.Model9XX;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class Mks9xxDevice
extends Device {
    private static final String DEVC_ID = "devcId";
    private static final String BUS_ADDR = "busAddr";
    @ConfigurationParameter(name="devcId", category="Cryo", isFinal=true)
    private String devcId;
    @ConfigurationParameter(name="busAddr", category="Cryo", isFinal=true)
    private int busAddr = 253;
    private Multidrop.ConnType connType = Multidrop.ConnType.SERIAL;
    private int baudRate = 9600;
    private static final Logger LOG = Logger.getLogger((String)Mks9xxDevice.class.getName());
    private final Model9XX mks = new Model9XX();
    private int errorCount = 0;

    public void initDevice() {
        if (this.devcId == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)DEVC_ID, (String)"is missing");
        }
        this.fullName = "MKS model 9XX (" + this.devcId + ":" + this.busAddr + ")";
    }

    public void initialize() {
        try {
            this.mks.open(this.connType, this.devcId, this.baudRate, this.busAddr);
            this.mks.setLock(false);
            this.mks.setPressureUnit(Model9XX.Unit.TORR);
            this.mks.setLock(true);
            this.errorCount = 0;
            this.setOnline(true);
            this.initSensors();
            LOG.info((Object)("Connected to " + this.fullName + ": model = " + this.mks.getModel() + ", serial no. = " + this.mks.getSerialNumber()));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    public void close() {
        try {
            this.mks.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    public double readChannel(int hwChan, int type) {
        double value;
        block3: {
            value = Double.NaN;
            if (this.online) {
                try {
                    value = this.mks.readPressure(Model9XX.Sensor.COMB4);
                    this.errorCount = 0;
                }
                catch (DriverException e) {
                    LOG.error((Object)("Error reading pressure from " + this.fullName + ": " + (Object)((Object)e)));
                    if (++this.errorCount < 5) break block3;
                    this.setOnline(false);
                }
            }
        }
        return value;
    }
}

