/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pluto.Pluto;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class VacPlutoDevice
extends Device {
    public static final int SW_BLOCK_HVSTAT = 0;
    public static final int SW_BLOCK_CVSTAT = 1;
    public static final int SW_OPEN_VHX00 = 2;
    public static final int SW_OPEN_VCR00 = 3;
    public static final int SW_OPEN_VCR01 = 4;
    public static final int SW_OPEN_VCR02 = 5;
    public static final int SW_OPEN_VCR03 = 6;
    public static final int SW_OPEN_VCR04 = 7;
    public static final int SW_BLOCK_HVPUMP = 8;
    public static final int SW_BLOCK_CVPUMP = 9;
    public static final int NUM_SWITCHES = 10;
    private static final int TYPE_GLOBAL = 0;
    private static final int TYPE_ADD_BIT = 1;
    private static final int TYPE_ADD_REG = 2;
    private static final int NUM_AREAS = 19;
    private static final int SWDI_ON_BIT = 0;
    private static final int SWDI_OFF_BIT = 1;
    private static final int SWDI_READ_AREA = 2;
    private static final int SWDI_READ_BIT = 3;
    private static final int CNDI_RESET_BIT = 0;
    private static final int CNDI_READ_AREA = 1;
    private static final int CNDI_READ_BIT = 2;
    private static final int CNDI_PEND_AREA = 3;
    private static final int CNDI_PEND_BIT = 4;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private static final int[][] switches;
    private static final int[][] conditions;
    private String node;
    private List<Integer> condsUsed;
    private final Pluto plu = new Pluto();
    private final int[] globData = new int[32];
    private final int[] addData = new int[32];
    private final Set<Integer> modsUsed = new HashSet<Integer>();
    private final Set<Integer> areasUsed = new HashSet<Integer>();

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"node", (String)"is missing");
        }
        if (this.condsUsed == null) {
            this.condsUsed = new ArrayList<Integer>();
        }
        for (int cond : this.condsUsed) {
            if (cond >= 0 && cond < 8) continue;
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"condsUsed item", (String)"is invalid");
        }
        this.fullName = "Pluto PLC system (" + this.node + ")";
    }

    protected void initialize() {
        try {
            this.plu.open(this.node);
            this.setOnline(true);
            this.initSensors();
            this.setOutputLines();
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.plu.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = null;
        int id = -1;
        String[] typeFields = type.split(":", -1);
        if (typeFields.length == 2) {
            iType = typeMap.get(typeFields[0].toUpperCase());
            try {
                id = Integer.decode(typeFields[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int maxId = 0;
        if (iType != null) {
            int maxChan;
            int n = maxId = iType == 0 ? 32 : 19;
            int n2 = iType == 0 ? 32 : (maxChan = iType == 1 ? 16 : 2);
            if (hwChan < 0 || hwChan >= maxChan) {
                MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hwchan", (Object)hwChan);
            }
        }
        if (iType == null || id < 0 || id >= maxId) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        }
        Set<Integer> used = iType == 0 ? this.modsUsed : this.areasUsed;
        used.add(id);
        return new int[]{iType << 8 | id, 0};
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            for (int id : this.modsUsed) {
                this.globData[id] = this.plu.readGlobalData(id);
            }
            for (int id : this.areasUsed) {
                this.addData[id] = this.plu.readAdditionalData(id);
            }
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            int index = type & 0xFF;
            switch (type >> 8) {
                case 0: {
                    value = this.globData[index] >> hwChan & 1;
                    break;
                }
                case 1: {
                    value = this.addData[index] >> hwChan & 1;
                    break;
                }
                case 2: {
                    value = this.addData[index] << 16 * (1 - hwChan) >> 16;
                }
            }
        }
        return value;
    }

    public void setSwitchOn(int sw, boolean on) {
        int bitNum = switches[sw][on ? 0 : 1];
        this.writeBit(bitNum / 16, bitNum & 0xF, 1);
        this.sleep(200);
        this.writeBit(bitNum / 16, bitNum & 0xF, 0);
    }

    public Boolean isSwitchOn(int sw) {
        int[] swData = switches[sw];
        Integer value = this.readAddBit(swData[2], swData[3] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public List<Integer> getConditionIds() {
        return this.condsUsed;
    }

    public Boolean isConditionActive(int cond) {
        int[] condData = conditions[cond];
        Integer value = this.readAddBit(condData[1], condData[2] + 16);
        return value != null ? Boolean.valueOf(value == 0) : null;
    }

    public Boolean isConditionLatched(int cond) {
        int[] condData = conditions[cond];
        Integer value = this.readAddBit(condData[3], condData[4] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public void clearCondition(int cond) {
        int bitNum = conditions[cond][0];
        this.writeBit(bitNum / 16, bitNum & 0xF, 1);
        this.sleep(200);
        this.writeBit(bitNum / 16, bitNum & 0xF, 0);
    }

    void writeBit(int area, int bit, int value) {
        try {
            this.plu.writeAreaBit(area, bit, value);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    int readBit(int area, int bit) {
        try {
            return this.plu.readAreaBit(area, bit);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return 0;
        }
    }

    Integer readAddBit(int area, int bit) {
        if (!this.online) {
            return null;
        }
        try {
            return this.plu.readAdditionalData(area) >> bit & 1;
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return null;
        }
    }

    void writeRegister(int area, int reg, int value) {
        try {
            this.plu.writeAreaRegister(area, reg, value);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        typeMap.put("GLOBAL", 0);
        typeMap.put("ADDBIT", 1);
        typeMap.put("ADDREG", 2);
        switches = new int[10][];
        VacPlutoDevice.switches[3] = new int[]{7, 6, 15, 0};
        VacPlutoDevice.switches[4] = new int[]{12, 13, 12, 0};
        VacPlutoDevice.switches[5] = new int[]{14, 15, 12, 3};
        VacPlutoDevice.switches[6] = new int[]{16, 17, 13, 0};
        VacPlutoDevice.switches[7] = new int[]{18, 19, 13, 3};
        VacPlutoDevice.switches[2] = new int[]{3, 2, 15, 2};
        VacPlutoDevice.switches[0] = new int[]{0, 20, 14, 0};
        VacPlutoDevice.switches[1] = new int[]{1, 21, 14, 3};
        VacPlutoDevice.switches[8] = new int[]{10, 22, 11, 0};
        VacPlutoDevice.switches[9] = new int[]{11, 23, 11, 3};
        conditions = new int[8][];
        VacPlutoDevice.conditions[0] = new int[]{1, 14, 3, 18, 0};
        VacPlutoDevice.conditions[2] = new int[]{9, 15, 4, 18, 2};
        VacPlutoDevice.conditions[1] = new int[]{8, 10, 3, 18, 1};
        VacPlutoDevice.conditions[3] = new int[]{11, 11, 3, 18, 3};
        VacPlutoDevice.conditions[4] = new int[]{0, 14, 0, 18, 4};
        VacPlutoDevice.conditions[6] = new int[]{5, 15, 5, 18, 6};
        VacPlutoDevice.conditions[5] = new int[]{4, 9, 3, 18, 5};
        VacPlutoDevice.conditions[7] = new int[]{10, 11, 0, 18, 7};
    }
}

