/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.twistorr.TwisTorr84;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.vacuum.CryoTurboDevice;
import org.lsst.ccs.subsystem.vacuum.HxTurboDevice;
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchNames;
import org.lsst.ccs.subsystem.vacuum.TwisTorr84Device;
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.data.VacuumException;
import org.lsst.ccs.subsystem.vacuum.data.VacuumState;
import org.lsst.ccs.utilities.logging.Logger;

public class PumpPlate
implements HasLifecycle {
    private static final double PRESS_20 = 20.0;
    private static final double PRESS_10 = 10.0;
    private static final double PRESS_5 = 5.0;
    private static final double PRESS_MID = 0.09;
    private static final double PRESS_ION_OFF = 1.0E-5;
    private static final double PRESS_ION_ENABLE = 1.0E-6;
    private static final double TURBO_MAX = 60000.0;
    private static final double TURBO_LOW = 6000.0;
    private static final double TURBO_HIGH = 30000.0;
    private static final int[] switchChannels = new int[17];
    private static final Map<String, DeviceState> turboStateMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private VacPlutoDevice plutoDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private CryoTurboDevice cryoTurboDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private HxTurboDevice hxTurboDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private IonPumpDevice ionPumpDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, Channel> channelMap = new LinkedHashMap<String, Channel>();
    private String platePressChan;
    private String turboPressChan;
    private String turboSpeedChan;
    private String forelinePressChan;
    private List<Integer> switches;
    private final Logger log = Logger.getLogger((String)this.getClass().getPackage().getName());
    private final VacuumState vacState = new VacuumState();
    private Set<Integer> switchSet;
    private final Device[] switchDevices = new Device[17];
    private Channel platePressure;
    private Channel turboPressure;
    private Channel turboSpeed;
    private Channel forelinePressure;
    private boolean running = false;
    private final Map<String, Integer> switchNameMap = new LinkedHashMap<String, Integer>();

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("vacuum-state", () -> this.updateVacuumState()).withPeriod(Duration.ofMillis(1000L));
        this.pts.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        int sw;
        this.subsys.setAgentProperty("vacuumType", PumpPlate.class.getCanonicalName());
        if (this.switches != null) {
            this.switchSet = new HashSet<Integer>(this.switches);
        } else {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"Switch list", (String)"not specified");
        }
        if (this.plutoDevc != null) {
            for (int cond : this.plutoDevc.getConditionIds()) {
                this.vacState.addCondition(cond);
                this.vacState.setCondition(cond, ConditionState.CLEAR);
            }
        } else {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"Pluto device", (String)"not specified");
        }
        if (this.cryoTurboDevc == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"Cryo turbo pump device", (String)"not specified");
        }
        if (this.ionPumpDevc == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"Ion pump device", (String)"not specified");
        }
        if (this.forelinePressChan != null) {
            this.forelinePressure = this.channelMap.get(this.forelinePressChan);
        }
        if (this.forelinePressure == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"Foreline pressure channel", (String)"not specified or not defined");
        }
        if (this.platePressChan != null) {
            this.platePressure = this.channelMap.get(this.platePressChan);
        }
        if (this.platePressure == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"Plate pressure channel", (String)"not specified or not defined");
        }
        if (this.turboPressChan != null) {
            this.turboPressure = this.channelMap.get(this.turboPressChan);
        }
        if (this.turboPressure == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"Turbo pump pressure channel", (String)"not specified or not defined");
        }
        if (this.turboSpeedChan != null) {
            this.turboSpeed = this.channelMap.get(this.turboSpeedChan);
        }
        if (this.turboSpeed == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"Turbo pump speed channel", (String)"not specified or not defined");
        }
        List<Integer> ipChannels = this.ionPumpDevc.getChannelNumbers();
        Iterator<Object> iterator = this.switchSet.iterator();
        while (iterator.hasNext()) {
            sw = iterator.next();
            switch (sw) {
                case 0: {
                    this.switchDevices[sw] = this.cryoTurboDevc;
                    break;
                }
                case 8: {
                    this.switchDevices[sw] = this.hxTurboDevc;
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    this.switchDevices[sw] = this.plutoDevc;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 12: {
                    this.switchDevices[sw] = this.ionPumpDevc;
                    if (ipChannels.contains(switchChannels[sw])) break;
                    this.switchSet.remove(sw);
                }
            }
        }
        iterator = this.switchSet.iterator();
        while (iterator.hasNext()) {
            sw = iterator.next();
            this.vacState.addSwitch(sw);
            this.vacState.setSwitchState(sw, SwitchState.OFFLINE);
            this.vacState.setSwitchEnable(sw, SwitchEnable.OFF);
        }
        for (String swName : SwitchNames.NAME_MAP.keySet()) {
            int sw2 = SwitchNames.NAME_MAP.get(swName);
            if (!this.switchSet.contains(sw2)) continue;
            this.switchNameMap.put(swName, sw2);
        }
    }

    public void postStart() {
        this.log.info((Object)"Pump plate subsystem started");
        this.running = true;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the pump plate state")
    public VacuumState getVacuumState() {
        this.vacState.setTickMillis(this.getTickPeriod());
        return this.vacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names")
    public List<String> getSwitchNames() throws VacuumException {
        return new ArrayList<String>(this.switchNameMap.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a switch")
    public void setSwitchOn(@Argument(description="The switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        try {
            if (!this.switchSet.contains(sw)) {
                throw new VacuumException("Invalid switch number: " + sw);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        Integer sw = this.switchNameMap.get(name);
        try {
            if (sw == null) {
                throw new VacuumException("Invalid switch name: " + name);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    private void setSwitch(int sw, boolean on) throws VacuumException {
        SwitchState state = this.vacState.getSwitchState(sw);
        if (state == SwitchState.OFFLINE) {
            return;
        }
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        if (on && enable != SwitchEnable.ON && enable != SwitchEnable.WAS_ON) {
            return;
        }
        Device swDevice = this.switchDevices[sw];
        try {
            if (swDevice instanceof TwisTorr84Device) {
                if (on) {
                    ((TwisTorr84Device)swDevice).startTurboPump();
                } else {
                    ((TwisTorr84Device)swDevice).stopTurboPump();
                }
            } else if (swDevice == this.plutoDevc) {
                this.plutoDevc.setSwitchOn(switchChannels[sw], on);
            } else if (swDevice == this.ionPumpDevc) {
                this.ionPumpDevc.setChannelOn(switchChannels[sw], on);
            }
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    private Boolean isSwitchOn(int sw) {
        Boolean value = false;
        Device swDevice = this.switchDevices[sw];
        if (swDevice instanceof TwisTorr84Device) {
            try {
                DeviceState st = turboStateMap.get(((TwisTorr84Device)swDevice).readTurboStatus());
                value = st != DeviceState.STOPPED && st != DeviceState.BRAKING;
            }
            catch (DriverException e) {
                value = null;
            }
        } else if (swDevice == this.plutoDevc) {
            value = this.plutoDevc.isSwitchOn(switchChannels[sw]);
        } else if (swDevice == this.ionPumpDevc) {
            value = this.ionPumpDevc.isChannelOn(switchChannels[sw]);
        }
        return value;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a condition")
    public void clearCondition(@Argument(description="The condition number") int cond) throws VacuumException {
        try {
            this.plutoDevc.clearCondition(cond);
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.vacState.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    private void updateVacuumState() {
        if (!this.running) {
            return;
        }
        double forelinePr = this.forelinePressure.getValue();
        double platePr = this.platePressure.getValue();
        double turboPr = this.turboPressure.getValue();
        double turboSp = this.turboSpeed.getValue();
        boolean changed = false;
        for (int sw = 0; sw < 17; ++sw) {
            SwitchEnable enabled;
            Boolean isOn;
            if (!this.vacState.hasSwitch(sw)) continue;
            Boolean enable = false;
            boolean turnOff = false;
            DeviceState devState = null;
            switch (sw) {
                case 7: {
                    if (!(Double.isNaN(platePr) || Double.isNaN(turboPr) || Double.isNaN(turboSp))) {
                        double prDiff = Math.abs(turboPr - platePr);
                        enable = prDiff <= 20.0 && turboSp < 6000.0 || prDiff <= 0.09 && turboSp > 30000.0;
                    }
                    if (!enable.booleanValue() || Double.isNaN(forelinePr) || Double.isNaN(turboSp)) break;
                    enable = forelinePr < 5.0 || turboSp < 30000.0;
                    turnOff = enable == false;
                    break;
                }
                case 0: {
                    if (!Double.isNaN(turboPr)) {
                        enable = turboPr < 10.0;
                        boolean bl = turnOff = enable == false;
                    }
                    if (enable.booleanValue() && !Double.isNaN(forelinePr) && !Double.isNaN(turboSp)) {
                        enable = forelinePr < 5.0 || turboSp < 30000.0;
                        turnOff = enable == false;
                    }
                    try {
                        devState = turboStateMap.get(((CryoTurboDevice)this.switchDevices[sw]).readTurboStatus());
                    }
                    catch (DriverException prDiff) {}
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    if (Double.isNaN(platePr)) break;
                    enable = platePr < 1.0E-6;
                    turnOff = platePr >= 1.0E-5;
                }
            }
            SwitchState oldState = this.vacState.getSwitchState(sw);
            if (turnOff && oldState == SwitchState.ON) {
                try {
                    this.setSwitch(sw, false);
                }
                catch (VacuumException e) {
                    this.log.error((Object)("Error setting switch: " + (Object)((Object)e)));
                }
            }
            SwitchState state = (isOn = this.isSwitchOn(sw)) != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : SwitchState.OFFLINE;
            SwitchEnable oldEnabled = this.vacState.getSwitchEnable(sw);
            if (enable == null) {
                enabled = oldEnabled == SwitchEnable.OFF ? SwitchEnable.WAS_OFF : (oldEnabled == SwitchEnable.ON ? SwitchEnable.WAS_ON : oldEnabled);
            } else {
                SwitchEnable switchEnable = enabled = enable != false ? SwitchEnable.ON : SwitchEnable.OFF;
            }
            if (state != oldState || enabled != oldEnabled) {
                this.vacState.setSwitchState(sw, state);
                this.vacState.setSwitchEnable(sw, enabled);
                changed = true;
            }
            DeviceState oldDevState = this.vacState.getDeviceState(sw);
            this.vacState.setDeviceState(sw, devState);
            if (devState == oldDevState) continue;
            changed = true;
        }
        for (int cond = 0; cond < 8; ++cond) {
            ConditionState state;
            if (!this.vacState.hasCondition(cond)) continue;
            Boolean active = this.plutoDevc.isConditionActive(cond);
            Boolean latched = this.plutoDevc.isConditionLatched(cond);
            ConditionState conditionState = active == null || latched == null ? ConditionState.OFFLINE : (latched != false ? ConditionState.LATCHED : (state = active != false ? ConditionState.ACTIVE : ConditionState.CLEAR));
            if (state == this.vacState.getCondition(cond)) continue;
            this.vacState.setCondition(cond, state);
            changed = true;
        }
        if (changed) {
            this.publishState();
        }
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("VacuumState", (Serializable)this.getVacuumState()));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    static {
        PumpPlate.switchChannels[1] = 0;
        PumpPlate.switchChannels[2] = 1;
        PumpPlate.switchChannels[3] = 2;
        PumpPlate.switchChannels[4] = 3;
        PumpPlate.switchChannels[5] = 4;
        PumpPlate.switchChannels[6] = 5;
        PumpPlate.switchChannels[9] = 6;
        PumpPlate.switchChannels[10] = 7;
        PumpPlate.switchChannels[12] = 8;
        PumpPlate.switchChannels[7] = 3;
        PumpPlate.switchChannels[11] = 2;
        PumpPlate.switchChannels[13] = 4;
        PumpPlate.switchChannels[14] = 5;
        PumpPlate.switchChannels[15] = 6;
        PumpPlate.switchChannels[16] = 7;
        turboStateMap = new HashMap<String, DeviceState>();
        turboStateMap.put(TwisTorr84.PumpStatus.STOP.name(), DeviceState.STOPPED);
        turboStateMap.put(TwisTorr84.PumpStatus.WAIT_INTLK.name(), DeviceState.WAITING);
        turboStateMap.put(TwisTorr84.PumpStatus.STARTING.name(), DeviceState.STARTNG);
        turboStateMap.put(TwisTorr84.PumpStatus.NORMAL.name(), DeviceState.NORMAL);
        turboStateMap.put(TwisTorr84.PumpStatus.BRAKING.name(), DeviceState.BRAKING);
        turboStateMap.put(TwisTorr84.PumpStatus.FAIL.name(), DeviceState.FAILED);
        turboStateMap.put(TwisTorr84.PumpStatus.AUTO_TUNING.name(), DeviceState.AUTOTUN);
    }
}

